/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.parser;

import org.firebirdsql.jaybird.parser.AbstractToken;
import org.firebirdsql.jaybird.parser.LiteralToken;

final class StringLiteralToken
extends AbstractToken
implements LiteralToken {
    private static final int STRING_LITERAL_MIN_SIZE = 2;
    private static final int Q_LITERAL_MIN_SIZE = 5;
    private static final int X_LITERAL_MIN_SIZE = 3;

    StringLiteralToken(int pos, CharSequence src, int start, int end) {
        super(pos, src, start, end);
    }

    public StringLiteralToken(int pos, CharSequence tokenText) {
        super(pos, tokenText);
    }

    public String value() {
        int textLength = this.length();
        if (textLength < 2) {
            throw new IllegalStateException("String literal too short, full text: " + this.text());
        }
        char firstChar = this.charAt(0);
        switch (firstChar) {
            case '\'': {
                this.checkEndsInQuote();
                String value = this.subSequence(1, textLength - 1).toString();
                return value.indexOf(39) == -1 ? value : value.replaceAll("''", "'");
            }
            case 'Q': 
            case 'q': {
                if (textLength < 5) {
                    throw new IllegalStateException("String literal too short, full text: " + this.text());
                }
                this.checkEndsInQuote();
                return this.subSequence(3, textLength - 2).toString();
            }
            case 'X': 
            case 'x': {
                if (textLength < 3) {
                    throw new IllegalStateException("String literal too short, full text: " + this.text());
                }
                this.checkEndsInQuote();
                return this.subSequence(2, textLength - 1).toString();
            }
        }
        throw new IllegalStateException(String.format("String literal starts with unexpected character '%s', full text: %s", Character.valueOf(firstChar), this.text()));
    }

    private void checkEndsInQuote() {
        char lastChar = this.charAt(this.length() - 1);
        if (lastChar != '\'') {
            throw new IllegalStateException(String.format("String literal ends with unexpected character '%s', expected: ''', full text: %s", Character.valueOf(lastChar), this.text()));
        }
    }
}

