/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.firebirdsql.gds.ng.wire.AsynchronousChannelListener;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class AsynchronousProcessor {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousProcessor.class);
    private final AsynchronousChannelListener channelListener = new ProcessorChannelListener();
    private final List<FbWireAsynchronousChannel> newChannels = Collections.synchronizedList(new ArrayList());
    private final SelectorTask selectorTask = new SelectorTask();
    private final Selector selector;

    private AsynchronousProcessor() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to initialize asynchronous processor", e);
        }
        Thread selectorThread = new Thread((Runnable)this.selectorTask, "Jaybird asynchronous processing");
        selectorThread.setDaemon(true);
        selectorThread.setUncaughtExceptionHandler(new LogUncaughtExceptionHandler());
        selectorThread.start();
    }

    public static AsynchronousProcessor getInstance() {
        return ProcessorHolder.INSTANCE;
    }

    public void registerAsynchronousChannel(FbWireAsynchronousChannel channel) {
        this.newChannels.add(channel);
        channel.addChannelListener(this.channelListener);
        this.selector.wakeup();
    }

    public void shutdown() {
        this.selectorTask.stop();
        this.selector.wakeup();
    }

    private static class LogUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private LogUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.errorfe("Jaybird asynchronous processing terminated. Uncaught exception on %s", t.getName(), e);
        }
    }

    private class SelectorTask
    implements Runnable {
        private volatile boolean running = true;

        private SelectorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running && !Thread.currentThread().isInterrupted()) {
                try {
                    List list = AsynchronousProcessor.this.newChannels;
                    synchronized (list) {
                        for (FbWireAsynchronousChannel channel : AsynchronousProcessor.this.newChannels) {
                            this.addChannel(channel);
                        }
                        AsynchronousProcessor.this.newChannels.clear();
                    }
                    if (AsynchronousProcessor.this.selector.select() == 0) continue;
                    this.handleReadableKeys(AsynchronousProcessor.this.selector.selectedKeys());
                }
                catch (IOException ex) {
                    log.error("IOException in async event processing", ex);
                }
            }
            try {
                AsynchronousProcessor.this.selector.close();
            }
            catch (IOException e) {
                log.error("IOException closing event selector", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleReadableKeys(Set<SelectionKey> selectedKeys) {
            Set<SelectionKey> set = selectedKeys;
            synchronized (set) {
                Iterator<SelectionKey> selectedKeysIterator = selectedKeys.iterator();
                while (selectedKeysIterator.hasNext()) {
                    SelectionKey selectionKey = selectedKeysIterator.next();
                    selectedKeysIterator.remove();
                    if (!selectionKey.isValid()) continue;
                    this.handleReadable(selectionKey);
                }
            }
        }

        private void addChannel(FbWireAsynchronousChannel channel) throws ClosedChannelException {
            try {
                channel.getSocketChannel().register(AsynchronousProcessor.this.selector, 1, channel);
            }
            catch (SQLException ex) {
                channel.removeChannelListener(AsynchronousProcessor.this.channelListener);
            }
        }

        private void handleReadable(SelectionKey selectionKey) {
            try {
                FbWireAsynchronousChannel channel;
                ByteBuffer eventBuffer;
                if (!selectionKey.isReadable()) {
                    return;
                }
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                int count = socketChannel.read(eventBuffer = (channel = (FbWireAsynchronousChannel)selectionKey.attachment()).getEventBuffer());
                if (count > 0) {
                    channel.processEventData();
                } else if (count < 0) {
                    try {
                        channel.close();
                    }
                    catch (SQLException e) {
                        log.error("SQLException closing event channel", e);
                    }
                }
            }
            catch (AsynchronousCloseException e) {
                log.debug("AsynchronousCloseException reading from event channel; cancelling key", e);
                selectionKey.cancel();
            }
            catch (CancelledKeyException e) {
            }
            catch (Exception e) {
                log.errorfe("%s reading from event channel; attempting to close async channel", e.getClass().getName(), e);
                FbWireAsynchronousChannel channel = (FbWireAsynchronousChannel)selectionKey.attachment();
                try {
                    channel.close();
                }
                catch (Exception e1) {
                    log.error("Attempt to close async channel failed", e1);
                }
            }
        }

        private void stop() {
            this.running = false;
        }
    }

    private class ProcessorChannelListener
    implements AsynchronousChannelListener {
        private ProcessorChannelListener() {
        }

        @Override
        public void channelClosing(FbWireAsynchronousChannel channel) {
            if (!AsynchronousProcessor.this.newChannels.remove(channel)) {
                for (SelectionKey key : new ArrayList<SelectionKey>(AsynchronousProcessor.this.selector.keys())) {
                    if (!key.isValid() || key.attachment() != channel) continue;
                    key.cancel();
                    break;
                }
            }
            channel.removeChannelListener(this);
        }

        @Override
        public void eventReceived(FbWireAsynchronousChannel channel, AsynchronousChannelListener.Event event) {
        }
    }

    private static class ProcessorHolder {
        private static final AsynchronousProcessor INSTANCE = new AsynchronousProcessor();

        private ProcessorHolder() {
        }
    }
}

