/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.firebirdsql.ds.FBAbstractCommonDataSource;
import org.firebirdsql.ds.FBConnectionPoolDataSource;
import org.firebirdsql.ds.FBSimpleDataSource;
import org.firebirdsql.ds.FBXADataSource;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.logging.LoggerFactory;

public class DataSourceFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        String className;
        Reference ref = (Reference)obj;
        switch (className = ref.getClassName()) {
            case "org.firebirdsql.ds.FBConnectionPoolDataSource": {
                return this.loadConnectionPoolDS(ref);
            }
            case "org.firebirdsql.ds.FBXADataSource": {
                return this.loadXADS(ref);
            }
            case "org.firebirdsql.ds.FBSimpleDataSource": {
                return this.loadSimpleDS(ref);
            }
        }
        return null;
    }

    private Object loadConnectionPoolDS(Reference ref) {
        FBConnectionPoolDataSource ds = new FBConnectionPoolDataSource();
        this.loadAbstractCommonDataSource(ds, ref);
        return ds;
    }

    private Object loadXADS(Reference ref) {
        FBXADataSource ds = new FBXADataSource();
        this.loadAbstractCommonDataSource(ds, ref);
        return ds;
    }

    private Object loadSimpleDS(Reference ref) {
        RefAddr propertyContent = ref.get("mcf");
        FBManagedConnectionFactory mcf = null;
        if (propertyContent != null) {
            byte[] data = (byte[])propertyContent.getContent();
            mcf = (FBManagedConnectionFactory)DataSourceFactory.deserialize(data);
        }
        if (mcf == null) {
            mcf = new FBManagedConnectionFactory(false);
        }
        FBSimpleDataSource ds = new FBSimpleDataSource(mcf);
        ds.setDescription(DataSourceFactory.getRefAddr(ref, "description"));
        return ds;
    }

    private void loadAbstractCommonDataSource(FBAbstractCommonDataSource ds, Reference ref) {
        RefAddr propertyContent = ref.get("properties");
        if (propertyContent != null) {
            byte[] data = (byte[])propertyContent.getContent();
            FBConnectionProperties props = (FBConnectionProperties)DataSourceFactory.deserialize(data);
            ds.setConnectionProperties(props);
        }
        ds.setDescription(DataSourceFactory.getRefAddr(ref, "description"));
    }

    protected static String getRefAddr(Reference ref, String type) {
        RefAddr addr = ref.get(type);
        if (addr == null) {
            return null;
        }
        Object content = addr.getContent();
        return content != null ? content.toString() : null;
    }

    protected static byte[] serialize(Object obj) throws NamingException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(obj);
            out.flush();
            return bout.toByteArray();
        }
        catch (IOException e) {
            NamingException namingException = new NamingException("Could not serialize object");
            namingException.initCause(e);
            throw namingException;
        }
    }

    protected static Object deserialize(byte[] data) {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        try {
            ObjectInputStream in = new ObjectInputStream(bin);
            return in.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            LoggerFactory.getLogger(DataSourceFactory.class).warn("Could not deserialize object, returning null", ex);
            return null;
        }
    }
}

