/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DirectPathBufferMarshaler;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;

class T4CTTIodpls
extends T4CTTIfun {
    private static final int DPLSDEF_IN_PARMCOUNT = 1;
    private static final int DPLSDEF_IN_FLAG = 0;
    private static final int DPLSDEF_IN_KLA_PARSE_RESET = 2;
    private static final int STREAM_VERSION = 400;
    private int dplscsr;
    private int dplsbufl;
    private DirectPathBufferMarshaler.BufferPlanner dplsbufPlan;
    private int dplsvrsn;
    private long[] dplsi4;
    private int dplsi4l;
    private long[] dplso4;
    int startErrorOffset;
    int endErrorOffset;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    T4CTTIodpls(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)129);
        this.clearState();
    }

    private void clearState() {
        this.dplscsr = 0;
        this.dplsbufPlan = null;
        this.dplsbufl = 0;
        this.dplsvrsn = 0;
        this.dplsi4 = new long[1];
        this.dplsi4l = 0;
        this.dplso4 = null;
    }

    void doODPLS(int cursorId, DirectPathBufferMarshaler.BufferPlanner bufferPlanner) throws IOException, SQLException {
        this.dplscsr = cursorId;
        this.dplsvrsn = 400;
        this.dplsbufPlan = bufferPlanner;
        do {
            this.dplsbufl = this.dplsbufPlan.preparePlan();
            this.doRPC();
        } while (!this.dplsbufPlan.isComplete());
        this.clearState();
    }

    void setI4Value(int key, long value) {
        this.dplsi4[key] = value;
        this.dplsi4l = Math.max(this.dplsi4l, key + 1);
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalSWORD(this.dplscsr);
        if (this.dplsbufl > 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.dplsbufl);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB4(this.dplsvrsn);
        if (this.dplsi4l > 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.dplsi4l);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.dplsbufl > 0) {
            DirectPathBufferMarshaler.marshal(this.dplsbufPlan, this.meg);
        }
        if (this.dplsi4l > 0) {
            for (int i2 = 0; i2 < this.dplsi4l; ++i2) {
                this.meg.marshalUB4(this.dplsi4[i2]);
            }
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int dplso4l = this.meg.unmarshalUB2();
        this.dplso4 = new long[dplso4l];
        for (int i2 = 0; i2 < dplso4l; ++i2) {
            this.dplso4[i2] = this.meg.unmarshalUB4();
        }
    }

    long getO4Value(int key) {
        return this.dplso4 != null && key < this.dplso4.length ? this.dplso4[key] : 0L;
    }

    @Override
    void processError() throws SQLException {
        try {
            super.processError();
        }
        catch (SQLException sqe) {
            byte[] oerepa = this.oer.oerepa;
            if (oerepa != null) {
                int position = this.getErrorOffset(oerepa, 0);
                this.getErrorOffset(oerepa, position);
            }
            throw sqe;
        }
    }

    private int getErrorOffset(byte[] oerepa, int position) {
        int startPosition = position;
        int len = oerepa[position++] & 0xFF;
        int errorOffset = 0;
        if (len + startPosition <= oerepa.length) {
            if (len == 0) {
                errorOffset = 0;
            } else if (len == 1) {
                errorOffset = oerepa[position++] & 0xFF;
            } else if (len == 2) {
                errorOffset = (oerepa[position++] & 0xFF) << 8 | oerepa[position++] & 0xFF;
            } else if (len == 4) {
                errorOffset = (oerepa[position++] & 0xFF) << 24 | (oerepa[position++] & 0xFF) << 16 | (oerepa[position++] & 0xFF) << 8 | oerepa[position++] & 0xFF;
            }
        }
        if (startPosition == 0) {
            this.startErrorOffset = errorOffset;
        } else {
            this.endErrorOffset = errorOffset;
        }
        return position;
    }

    static {
        try {
            $$$methodRef$$$8 = T4CTTIodpls.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIodpls.class.getDeclaredMethod("getErrorOffset", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIodpls.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIodpls.class.getDeclaredMethod("getO4Value", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIodpls.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIodpls.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIodpls.class.getDeclaredMethod("setI4Value", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIodpls.class.getDeclaredMethod("doODPLS", Integer.TYPE, DirectPathBufferMarshaler.BufferPlanner.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIodpls.class.getDeclaredMethod("clearState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

