/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
abstract class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = Short.MAX_VALUE;
    static final int TTCC_MXIN_OLD = 64;
    private int effectiveTTCC_MXIN;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short proSvrVer;
    static final byte[] NO_BYTES;
    boolean useCLRBigChunks;
    static final byte[] IGNORED;
    final byte[] tmpBuffer1;
    final byte[] tmpBuffer2;
    final byte[] tmpBuffer3;
    final byte[] tmpBuffer4;
    final byte[] tmpBuffer5;
    final byte[] tmpBuffer6;
    final byte[] tmpBuffer7;
    final byte[] tmpBuffer8;
    final byte[] tmpBuffer10;
    final int[] retLen;
    AtomicReference<OracleConnection> connForException;
    static final byte[] NULL_PTR;
    static final byte[] NOTNULL_PTR;
    ArrayList<byte[]> refVector;
    private ArrayList<byte[]> clrList;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    T4CMAREngine() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$51, null, new Object[0]);
            }
            this.effectiveTTCC_MXIN = 64;
            this.useCLRBigChunks = false;
            this.tmpBuffer1 = new byte[1];
            this.tmpBuffer2 = new byte[2];
            this.tmpBuffer3 = new byte[3];
            this.tmpBuffer4 = new byte[4];
            this.tmpBuffer5 = new byte[5];
            this.tmpBuffer6 = new byte[6];
            this.tmpBuffer7 = new byte[7];
            this.tmpBuffer8 = new byte[8];
            this.tmpBuffer10 = new byte[10];
            this.retLen = new int[1];
            this.connForException = new AtomicReference();
            this.refVector = null;
            this.clrList = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$51, null);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$51, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static String toHex(long l2, int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            String result;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$0, null, l2, n2);
            }
            switch (bytes) {
                case 1: {
                    long value;
                    result = "00" + Long.toString(value & 0xFFL, 16);
                    break;
                }
                case 2: {
                    long value;
                    result = "0000" + Long.toString(value & 0xFFFFL, 16);
                    break;
                }
                case 3: {
                    long value;
                    result = "000000" + Long.toString(value & 0xFFFFFFL, 16);
                    break;
                }
                case 4: {
                    long value;
                    result = "00000000" + Long.toString(value & 0xFFFFFFFFL, 16);
                    break;
                }
                case 5: {
                    long value;
                    result = "0000000000" + Long.toString(value & 0xFFFFFFFFFFL, 16);
                    break;
                }
                case 6: {
                    long value;
                    result = "000000000000" + Long.toString(value & 0xFFFFFFFFFFFFL, 16);
                    break;
                }
                case 7: {
                    long value;
                    result = "00000000000000" + Long.toString(value & 0xFFFFFFFFFFFFFFL, 16);
                    break;
                }
                case 8: {
                    long value;
                    String string = T4CMAREngine.toHex(value >> 32, 4) + T4CMAREngine.toHex(value, 4).substring(2);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$0, null, string);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$0, null, null);
                    }
                    return string;
                }
                default: {
                    String string = "more than 8 bytes";
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$0, null, string);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$0, null, null);
                    }
                    return "more than 8 bytes";
                }
            }
            String string = "0x" + result.substring(result.length() - 2 * bytes);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$0, null, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$0, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    static String toHex(byte by) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$1, null, by);
            }
            String result = "00" + Integer.toHexString(value & 0xFF);
            String string = "0x" + result.substring(result.length() - 2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$1, null, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$1, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    static String toHex(short s2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            short value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$2, null, s2);
            }
            String string = T4CMAREngine.toHex(value, 2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$2, null, string);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$2, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    static String toHex(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$3, null, n2);
            }
            String string = T4CMAREngine.toHex(value, 4);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$3, null, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$3, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static String toHex(byte[] byArray, int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            byte[] value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$4, null, byArray, n2);
            }
            if (value == null) {
                String string = "null";
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$4, null, string);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$4, null, null);
                }
                return "null";
            }
            if (length > value.length) {
                String string = "byte array not long enough";
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$4, null, string);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$4, null, null);
                }
                return "byte array not long enough";
            }
            String result = "[";
            int len = Math.min(64, (int)length);
            for (int i2 = 0; i2 < len; ++i2) {
                result = result + T4CMAREngine.toHex(value[i2]) + " ";
            }
            if (len < length) {
                result = result + "...";
            }
            String string = result + "]";
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$4, null, string);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$4, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    static String toHex(byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$5, null, new Object[]{byArray});
            }
            if (value == null) {
                String string = "null";
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$5, null, string);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$5, null, null);
                }
                return "null";
            }
            String string = T4CMAREngine.toHex(value, value.length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$5, null, string);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$5, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    abstract void marshalSB1(byte var1) throws IOException;

    abstract void marshalUB1(short var1) throws IOException;

    abstract void marshalSB2(short var1) throws IOException;

    abstract void marshalUB2(int var1) throws IOException;

    abstract void marshalNativeUB2(short var1, boolean var2) throws IOException;

    abstract void marshalSB4(int var1) throws IOException;

    abstract void marshalUB4(long var1) throws IOException;

    abstract void marshalUB8(long var1) throws IOException;

    abstract void marshalSB8(long var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    final void marshalSWORD(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$6, this, n2);
            }
            this.marshalSB4((int)value);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalUWORD(long l2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$7, this, l2);
            }
            this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract void marshalB1Array(byte[] var1) throws IOException;

    abstract void marshalB1Array(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    final void marshalUB4Array(long[] lArray) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$8, this, new Object[]{lArray});
            }
            for (int i2 = 0; i2 < ((void)value).length; ++i2) {
                this.marshalSB4((int)(value[i2] & 0xFFFFFFFFFFFFFFFFL));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalO2U(boolean bl) throws IOException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void notnull;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$9, this, bl);
            }
            if (notnull != false) {
                this.addPtr((byte)1);
            } else {
                this.addPtr((byte)0);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    final void marshalNULLPTR() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$10, this, new Object[0]);
            }
            this.addPtr((byte)0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    final void marshalPTR() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$11, this, new Object[0]);
            }
            this.addPtr((byte)1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalCHR(byte[] byArray) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$12, this, new Object[]{byArray});
            }
            this.marshalCHR((byte[])value, 0, ((void)value).length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalCHR(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$13, this, byArray, n2, n3);
            }
            if (length > 0) {
                void offset;
                void value;
                if (this.types.isConvNeeded()) {
                    this.marshalCLR((byte[])value, (int)offset, (int)length);
                } else {
                    this.marshalB1Array((byte[])value, (int)offset, (int)length);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalCLR(byte[] byArray, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void valueLen;
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$14, this, byArray, n2);
            }
            this.marshalCLR((byte[])value, 0, (int)valueLen);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalCLR(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void value;
            void valueLen;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$15, this, byArray, n2, n3);
            }
            if (valueLen > 252) {
                int len;
                int nbBytesWritten = 0;
                this.marshalUB1((short)-2);
                do {
                    void bytesLeft;
                    int n4 = len = (bytesLeft = valueLen - nbBytesWritten) > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : bytesLeft;
                    if (this.useCLRBigChunks) {
                        this.marshalSB4(len);
                    } else {
                        this.marshalUB1((byte)(len & 0xFF));
                    }
                    this.marshalB1Array((byte[])value, (int)(offset + nbBytesWritten), len);
                } while ((nbBytesWritten += len) < valueLen);
                this.marshalUB1((short)0);
            } else {
                this.marshalUB1((byte)(valueLen & 0xFF));
                if (((void)value).length != 0) {
                    this.marshalB1Array((byte[])value, (int)offset, (int)valueLen);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalCLR(DynamicByteArray dynamicByteArray, long l2, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void value;
            void valueLen;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$16, this, dynamicByteArray, l2, n2);
            }
            if (valueLen > 252) {
                int chunkLen;
                int nbBytesWritten = 0;
                this.marshalUB1((short)-2);
                do {
                    void bytesLeft;
                    int n3 = chunkLen = (bytesLeft = valueLen - nbBytesWritten) > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : bytesLeft;
                    if (this.useCLRBigChunks) {
                        this.marshalSB4(chunkLen);
                    } else {
                        this.marshalUB1((byte)(chunkLen & 0xFF));
                    }
                    value.marshalB1Array(this, (long)(offset + (long)nbBytesWritten), chunkLen);
                } while ((nbBytesWritten += chunkLen) < valueLen);
                this.marshalUB1((short)0);
            } else {
                this.marshalUB1((byte)(valueLen & 0xFF));
                if (value.length != 0L) {
                    value.marshalB1Array(this, (long)offset, (int)valueLen);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final void marshalCLR(InputStream inputStream, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$17, this, inputStream, n2);
            }
            int bufferLength = this.effectiveTTCC_MXIN;
            byte[] buffer = new byte[bufferLength];
            int bytesRead = 0;
            boolean endOfStream = false;
            this.marshalUB1((short)254);
            try {
                while (!endOfStream) {
                    void currentStream;
                    bytesRead = currentStream.read(buffer, 0, bufferLength);
                    if (bytesRead == -1) {
                        endOfStream = true;
                    }
                    if (bytesRead <= 0) continue;
                    if (this.useCLRBigChunks) {
                        this.marshalSB4(bytesRead);
                    } else {
                        this.marshalUB1((byte)(bytesRead & 0xFF));
                    }
                    this.marshalB1Array(buffer, 0, bytesRead);
                }
            }
            catch (Throwable throwable) {
                this.marshalUB1((short)0);
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$17, this, throwable2);
                }
                throw throwable2;
            }
            this.marshalUB1((short)0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$17, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalKEYVAL(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2, byte[] byArray3, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void nb;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$18, this, new Object[]{byArray, nArray, byArray2, nArray2, byArray3, n2});
            }
            for (int i2 = 0; i2 < nb; ++i2) {
                void kvalflg;
                void valuesSize;
                void values;
                void keysSize;
                void keys;
                if (keys[i2] != null && keysSize[i2] > 0) {
                    this.marshalUB4((long)keysSize[i2]);
                    this.marshalCLR((byte[])keys[i2], 0, (int)keysSize[i2]);
                } else {
                    this.marshalUB4(0L);
                }
                if (values[i2] != null && valuesSize[i2] > 0) {
                    this.marshalUB4((long)valuesSize[i2]);
                    this.marshalCLR((byte[])values[i2], 0, (int)valuesSize[i2]);
                } else {
                    this.marshalUB4(0L);
                }
                if (kvalflg[i2] != false) {
                    this.marshalUB4(1L);
                    continue;
                }
                this.marshalUB4(0L);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalKEYVAL(byte[][] byArray, byte[][] byArray2, byte[] byArray3, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void kvalflg;
            void values;
            void keys;
            int nb;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$19, this, new Object[]{byArray, byArray2, byArray3, n2});
            }
            int[] keysSize = new int[nb];
            int[] valuesSize = new int[nb];
            for (int i2 = 0; i2 < nb; ++i2) {
                if (keys[i2] != null) {
                    keysSize[i2] = ((void)keys[i2]).length;
                }
                if (values[i2] == null) continue;
                valuesSize[i2] = ((void)values[i2]).length;
            }
            this.marshalKEYVAL((byte[][])keys, keysSize, (byte[][])values, valuesSize, (byte[])kvalflg, nb);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalDALC(byte[] byArray) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$20, this, new Object[]{byArray});
            }
            if (buffer == null || ((void)buffer).length < 1) {
                this.marshalUB4(0L);
            } else {
                this.marshalUB4(((void)buffer).length);
                this.marshalCLR((byte[])buffer, ((void)buffer).length);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalKPDKV(byte[][] byArray, byte[][] byArray2, int[] nArray) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void textValues;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$21, this, new Object[]{byArray, byArray2, nArray});
            }
            for (int i2 = 0; i2 < ((void)textValues).length; ++i2) {
                void keywords;
                void binaryValues;
                if (textValues[i2] != null) {
                    this.marshalUB4(((void)textValues[i2]).length);
                    this.marshalCLR((byte[])textValues[i2], 0, ((void)textValues[i2]).length);
                } else {
                    this.marshalUB4(0L);
                }
                if (binaryValues[i2] != null) {
                    this.marshalUB4(((void)binaryValues[i2]).length);
                    this.marshalCLR((byte[])binaryValues[i2], 0, ((void)binaryValues[i2]).length);
                } else {
                    this.marshalUB4(0L);
                }
                this.marshalUB2((int)keywords[i2]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void unmarshalKPDKV(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void textValues;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$22, this, new Object[]{byArray, nArray, byArray2, nArray2});
            }
            int tempLength = 0;
            int[] tempAr = new int[1];
            for (int i2 = 0; i2 < ((void)textValues).length; ++i2) {
                tempLength = (int)this.unmarshalUB4();
                if (tempLength > 0) {
                    textValues[i2] = new byte[tempLength];
                    this.unmarshalCLR((byte[])textValues[i2], 0, tempAr, tempLength);
                    textValuesLength[i2] = tempAr[0];
                }
                if ((tempLength = (int)this.unmarshalUB4()) > 0) {
                    void binaryValues;
                    binaryValues[i2] = new byte[tempLength];
                    this.unmarshalCLR((byte[])binaryValues[i2], 0, tempAr, tempLength);
                }
                keywords[i2] = this.unmarshalUB2();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void addPtr(byte by) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$23, this, by);
            }
            if (this.types.rep[4] == 1) {
                this.marshalUB1((short)value);
            } else if (value == false) {
                this.marshalB1Array(NULL_PTR);
            } else {
                this.marshalB1Array(NOTNULL_PTR);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract byte unmarshalSB1() throws SQLException, IOException;

    abstract short unmarshalUB1() throws SQLException, IOException;

    abstract short unmarshalSB2() throws SQLException, IOException;

    /*
     * WARNING - void declaration
     */
    int unmarshalNativeUB2(boolean bl) throws SQLException, IOException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void isLsb;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$24, this, bl);
            }
            int value = 0;
            this.unmarshalNBytes(this.tmpBuffer2, 0, 2);
            value = isLsb != false ? this.tmpBuffer2[1] << 8 & 0xFF00 | this.tmpBuffer2[0] & 0xFF : this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
            int n2 = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$24, this, n2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$24, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract int unmarshalUB2() throws SQLException, IOException;

    /*
     * WARNING - void declaration
     */
    final int unmarshalUCS2(byte[] byArray, long l2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            void ucs2Char;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$25, this, byArray, l2);
            }
            int value = this.unmarshalUB2();
            this.tmpBuffer2[0] = (byte)((value & 0xFF00) >> 8);
            this.tmpBuffer2[1] = (byte)(value & 0xFF);
            if (offset + 1L < (long)((void)ucs2Char).length) {
                ucs2Char[(int)offset] = this.tmpBuffer2[0];
                ucs2Char[(int)offset + 1] = this.tmpBuffer2[1];
            } else if (bl) {
                this.debug($$$loggerRef$$$25, Level.FINEST, $$$methodRef$$$25, "T4CMAREngine.unmarshalUCS2: ucs2Char buffer too small");
            }
            int n3 = this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : (n2 = 3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$25, this, n2);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$25, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract int unmarshalSB4() throws SQLException, IOException;

    abstract long unmarshalUB4() throws SQLException, IOException;

    /*
     * WARNING - void declaration
     */
    final int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$26, this, new Object[]{byArray});
            }
            long value = this.buffer2Value((byte)2, new ByteArrayInputStream((byte[])buffer));
            int n2 = (int)value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$26, this, n2);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$26, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    final long unmarshalSB8() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$27, this, new Object[0]);
            }
            long l2 = value = this.buffer2Value((byte)3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$27, this, l2);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$27, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void buffer;
            int result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$28, this, new Object[]{byArray});
            }
            int n2 = result = this.unmarshalSB4((byte[])buffer);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$28, this, n2);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$28, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    int unmarshalSWORD() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$29, this, new Object[0]);
            }
            int n2 = result = (int)this.unmarshalUB4();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$29, this, n2);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$29, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    long unmarshalUWORD() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$30, this, new Object[0]);
            }
            long l2 = result = this.unmarshalUB4();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$30, this, l2);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$30, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract byte[] unmarshalNBytes(int var1) throws SQLException, IOException;

    abstract int unmarshalNBytes(byte[] var1, int var2, int var3) throws SQLException, IOException;

    abstract int getNBytes(byte[] var1, int var2, int var3) throws SQLException, IOException;

    abstract byte[] getNBytes(int var1) throws SQLException, IOException;

    abstract byte[] unmarshalTEXT(int var1) throws SQLException, IOException;

    /*
     * WARNING - void declaration
     */
    byte[] unmarshalCHR(int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void retLength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$31, this, n2);
            }
            byte[] resBuffer = null;
            if (this.types.isConvNeeded()) {
                resBuffer = this.unmarshalCLR((int)retLength, this.retLen);
                if (resBuffer.length != this.retLen[0]) {
                    byte[] tmpBuf = new byte[this.retLen[0]];
                    System.arraycopy(resBuffer, 0, tmpBuf, 0, this.retLen[0]);
                    resBuffer = tmpBuf;
                }
            } else {
                resBuffer = this.getNBytes((int)retLength);
            }
            byte[] byArray = resBuffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$31, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$31, this, null);
            }
            return resBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void unmarshalCLR(byte[] byArray, int n2, int[] nArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void intArray;
            void offsetRow;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$32, this, byArray, n2, nArray);
            }
            this.unmarshalCLR((byte[])bytes, (int)offsetRow, (int[])intArray, Integer.MAX_VALUE);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void maxSize;
            void intArray;
            void offsetRow;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$33, this, byArray, n2, nArray, n3);
            }
            this.unmarshalCLR((byte[])bytes, (int)offsetRow, (int[])intArray, (int)maxSize, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3, int n4) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void intArray;
            void bytes;
            void maxSize;
            void ignoreNBytes;
            void offsetRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this, byArray, n2, nArray, n3, n4);
            }
            int len = 0;
            int locallen = 0;
            int offset = offsetRow;
            int nbBytesWritten = 0;
            int keepThem = 0;
            int nbOfBytesIgnored = 0;
            len = this.unmarshalUB1();
            if (len < 0) {
                if (bl) {
                    this.debug($$$loggerRef$$$34, Level.FINEST, $$$methodRef$$$34, "T4CMAREngine.unmarshalCLR: length less than 0");
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this, sQLException);
                }
                throw sQLException;
            }
            if (len == 0) {
                intArray[0] = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this);
                    ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this, null);
                }
                return;
            }
            if (this.escapeSequenceNull(len)) {
                intArray[0] = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this);
                    ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this, null);
                }
                return;
            }
            if (len != 254) {
                if (ignoreNBytes - nbOfBytesIgnored >= len) {
                    this.unmarshalBuffer(IGNORED, 0, len);
                    nbOfBytesIgnored += len;
                    len = 0;
                } else if (ignoreNBytes - nbOfBytesIgnored > 0) {
                    this.unmarshalBuffer(IGNORED, 0, (int)(ignoreNBytes - nbOfBytesIgnored));
                    len -= ignoreNBytes - nbOfBytesIgnored;
                    nbOfBytesIgnored += ignoreNBytes - nbOfBytesIgnored;
                }
                if (len > 0) {
                    keepThem = Math.min((int)(maxSize - nbBytesWritten), len);
                    offset = this.unmarshalBuffer((byte[])bytes, offset, keepThem);
                    nbBytesWritten += keepThem;
                    int rest = len - keepThem;
                    if (rest > 0) {
                        this.unmarshalBuffer(IGNORED, 0, rest);
                    }
                }
            } else {
                while (true) {
                    int n5 = len = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1();
                    if (len <= 0) break;
                    if (offset == -1) {
                        this.unmarshalBuffer(IGNORED, 0, len);
                        continue;
                    }
                    locallen = len;
                    if (ignoreNBytes - nbOfBytesIgnored >= locallen) {
                        this.unmarshalBuffer(IGNORED, 0, locallen);
                        nbOfBytesIgnored += locallen;
                        locallen = 0;
                    } else if (ignoreNBytes - nbOfBytesIgnored > 0) {
                        this.unmarshalBuffer(IGNORED, 0, (int)(ignoreNBytes - nbOfBytesIgnored));
                        locallen -= ignoreNBytes - nbOfBytesIgnored;
                        nbOfBytesIgnored += ignoreNBytes - nbOfBytesIgnored;
                    }
                    if (locallen <= 0) continue;
                    keepThem = Math.min((int)(maxSize - nbBytesWritten), locallen);
                    offset = this.unmarshalBuffer((byte[])bytes, offset, keepThem);
                    nbBytesWritten += keepThem;
                    int rest = locallen - keepThem;
                    if (rest <= 0) continue;
                    this.unmarshalBuffer(IGNORED, 0, rest);
                }
            }
            if (intArray != null) {
                if (offset != -1) {
                    intArray[0] = nbBytesWritten;
                } else {
                    intArray[0] = ((void)bytes).length - offsetRow;
                    if (bl) {
                        this.debug($$$loggerRef$$$34, Level.FINEST, $$$methodRef$$$34, "T4CMAREngine.unmarshalCLR: exceeded the tmpBuffer length");
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final byte[] unmarshalCLR(int n2, int[] nArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void intArray;
            void buflen;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$35, this, n2, nArray);
            }
            byte[] tmpBuf = new byte[buflen * this.conv.c2sNlsRatio];
            this.unmarshalCLR(tmpBuf, 0, (int[])intArray, (int)buflen);
            byte[] byArray = tmpBuf;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$35, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$35, this, null);
            }
            return tmpBuf;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int[] unmarshalKEYVAL(byte[][] byArray, byte[][] byArray2, int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int nb;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$36, this, new Object[]{byArray, byArray2, n2});
            }
            byte[] buff = new byte[1000];
            int[] length = new int[1];
            int[] kvalflg = new int[nb];
            for (int i2 = 0; i2 < nb; ++i2) {
                int len = this.unmarshalSB4();
                if (len > 0) {
                    void keys;
                    this.unmarshalCLR(buff, 0, length);
                    keys[i2] = new byte[length[0]];
                    System.arraycopy(buff, 0, keys[i2], 0, length[0]);
                }
                if ((len = this.unmarshalSB4()) > 0) {
                    void values;
                    this.unmarshalCLR(buff, 0, length);
                    values[i2] = new byte[length[0]];
                    System.arraycopy(buff, 0, values[i2], 0, length[0]);
                }
                kvalflg[i2] = this.unmarshalSB4();
            }
            buff = null;
            int[] nArray = kvalflg;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$36, this, nArray);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$36, this, null);
            }
            return kvalflg;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int unmarshalBuffer(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _byteValue;
            int offset;
            void len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$37, this, byArray, n2, n3);
            }
            if (len <= 0) {
                void var5_5 = offset;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$37, this, (int)var5_5);
                    ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$37, this, null);
                }
                return (int)var5_5;
            }
            if (((void)_byteValue).length < offset + len) {
                this.unmarshalNBytes((byte[])_byteValue, offset, ((void)_byteValue).length - offset);
                this.unmarshalNBytes(IGNORED, 0, (int)(offset + len - ((void)_byteValue).length));
                offset = -1;
            } else {
                this.unmarshalNBytes((byte[])_byteValue, offset, (int)len);
                offset += len;
            }
            void var5_6 = offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$37, this, (int)var5_6);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$37, this, null);
            }
            return (int)var5_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    final byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$38, this, new Object[0]);
            }
            int len = 0;
            short totalLen = 0;
            byte[] finalBuffer = null;
            short bytes = this.unmarshalUB1();
            if (bytes < 0) {
                if (bl) {
                    this.debug($$$loggerRef$$$38, Level.FINEST, $$$methodRef$$$38, "T4CMAREngine.unmarshalCLRfroREFS: bytes < 0");
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$38, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$38, this, sQLException);
                }
                throw sQLException;
            }
            if (bytes == 0) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$38, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$38, this, null);
                }
                return null;
            }
            boolean isEscapeSequenceNull = this.escapeSequenceNull(bytes);
            if (!isEscapeSequenceNull) {
                if (this.refVector == null) {
                    this.refVector = new ArrayList(10);
                } else {
                    this.refVector.clear();
                }
            }
            if (!isEscapeSequenceNull) {
                byte[] tmpBuf;
                if (bytes == 254) {
                    while ((len = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                        if (len == 254 && !this.useCLRBigChunks && this.types.isServerConversion()) continue;
                        totalLen = (short)(totalLen + len);
                        tmpBuf = new byte[len];
                        this.unmarshalBuffer(tmpBuf, 0, len);
                        this.refVector.add(tmpBuf);
                    }
                } else {
                    totalLen = bytes;
                    tmpBuf = new byte[bytes];
                    this.unmarshalBuffer(tmpBuf, 0, bytes);
                    this.refVector.add(tmpBuf);
                }
                finalBuffer = new byte[totalLen];
                int start = 0;
                while (this.refVector.size() > 0) {
                    int arrayLen = this.refVector.get(0).length;
                    System.arraycopy(this.refVector.get(0), 0, finalBuffer, start, arrayLen);
                    start += arrayLen;
                    this.refVector.remove(0);
                }
            } else {
                finalBuffer = null;
            }
            byte[] byArray = finalBuffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$38, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$38, this, null);
            }
            return finalBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    final byte[] unmarshalCLR() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$39, this, new Object[0]);
            }
            int len = 0;
            short totalLen = 0;
            byte[] finalBuffer = null;
            short bytes = this.unmarshalUB1();
            if (bytes < 0) {
                if (bl) {
                    this.debug($$$loggerRef$$$39, Level.FINEST, $$$methodRef$$$39, "T4CMAREngine.unmarshalCLR bytes < 0");
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$39, this, sQLException);
                }
                throw sQLException;
            }
            if (bytes == 0) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$39, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$39, this, null);
                }
                return null;
            }
            boolean isEscapeSequenceNull = this.escapeSequenceNull(bytes);
            if (!isEscapeSequenceNull) {
                if (this.clrList == null) {
                    this.clrList = new ArrayList(10);
                } else {
                    this.clrList.clear();
                }
            }
            if (!isEscapeSequenceNull) {
                byte[] tmpBuf;
                if (bytes == 254) {
                    while ((len = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                        totalLen = (short)(totalLen + len);
                        tmpBuf = new byte[len];
                        this.unmarshalBuffer(tmpBuf, 0, len);
                        this.clrList.add(tmpBuf);
                    }
                } else {
                    totalLen = bytes;
                    tmpBuf = new byte[bytes];
                    this.unmarshalBuffer(tmpBuf, 0, bytes);
                    this.clrList.add(tmpBuf);
                }
                finalBuffer = new byte[totalLen];
                int start = 0;
                while (this.clrList.size() > 0) {
                    int arrayLen = this.clrList.get(0).length;
                    System.arraycopy(this.clrList.get(0), 0, finalBuffer, start, arrayLen);
                    start += arrayLen;
                    this.clrList.remove(0);
                }
            } else {
                finalBuffer = null;
            }
            byte[] byArray = finalBuffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$39, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$39, this, null);
            }
            return finalBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean escapeSequenceNull(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$40, this, n2);
            }
            boolean is_null = false;
            switch (bytes) {
                case 0: {
                    is_null = true;
                    break;
                }
                case 253: {
                    if (bl) {
                        this.debug($$$loggerRef$$$40, Level.FINEST, $$$methodRef$$$40, "T4CMAREngineStream.escapeSequenceNull: received an ESC");
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$40, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$40, this, sQLException);
                    }
                    throw sQLException;
                }
                case 255: {
                    if (bl) {
                        this.debug($$$loggerRef$$$40, Level.FINEST, $$$methodRef$$$40, "T4CMAREngineStream.escapeSequenceNull: received an ERROR");
                    }
                    is_null = true;
                    break;
                }
                case 254: {
                    break;
                }
            }
            boolean bl2 = is_null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$40, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$40, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int processIndicator(boolean bl, int n2) throws SQLException, IOException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void isNull;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$41, this, bl, n2);
            }
            short ind = this.unmarshalSB2();
            int res = 0;
            if (isNull == false) {
                int dataSize;
                res = ind == 0 ? dataSize : (ind == -2 || ind > 0 ? (int)ind : 65536 + ind);
            }
            int n3 = res;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$41, this, n3);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$41, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int unmarshalDALC(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$42, this, byArray, n2);
            }
            if ((len = (int)this.unmarshalUB4()) > 0) {
                void offset;
                void buffer;
                this.unmarshalCLR((byte[])buffer, (int)offset, this.retLen);
            }
            int n3 = len;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$42, this, n3);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$42, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    final byte[] unmarshalDALC() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] buffer;
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$43, this, new Object[0]);
            }
            if ((len = (int)this.unmarshalUB4()) > 0) {
                buffer = this.unmarshalCLR(len, this.retLen);
                if (buffer == null) {
                    if (bl) {
                        this.debug($$$loggerRef$$$43, Level.FINEST, $$$methodRef$$$43, "T4CMAREngine.unmarshalDALC: buffer == null");
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$43, this, sQLException);
                    }
                    throw sQLException;
                }
            } else {
                this.retLen[0] = 0;
                buffer = NO_BYTES;
            }
            byte[] byArray = buffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$43, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$43, this, null);
            }
            return buffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] buffer;
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$44, this, new Object[]{nArray});
            }
            if ((len = (int)this.unmarshalUB4()) > 0) {
                void CLRRetLen;
                buffer = this.unmarshalCLR(len, (int[])CLRRetLen);
                if (buffer == null) {
                    if (bl) {
                        this.debug($$$loggerRef$$$44, Level.FINEST, $$$methodRef$$$44, "T4CMAREngine.unmarshalDALC: buffer == null");
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$44, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$44, this, sQLException);
                    }
                    throw sQLException;
                }
            } else {
                CLRRetLen[0] = false;
                buffer = NO_BYTES;
            }
            byte[] byArray = buffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$44, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$44, this, null);
            }
            return buffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract long buffer2Value(byte var1) throws SQLException, IOException;

    /*
     * WARNING - void declaration
     */
    final long buffer2Value(byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] tmpBuffer;
            void in;
            void repOffset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, by, byteArrayInputStream);
            }
            int bufLength = 0;
            long value = 0L;
            boolean negative = false;
            if ((this.types.rep[repOffset] & 1) > 0) {
                bufLength = in.read();
                if ((bufLength & 0x80) > 0) {
                    bufLength &= 0x7F;
                    negative = true;
                }
                if (bufLength < 0) {
                    if (bl) {
                        this.debug($$$loggerRef$$$45, Level.FINEST, $$$methodRef$$$45, "T4CMAREngine.buffer2Value: bufLength < 0");
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, sQLException);
                    }
                    throw sQLException;
                }
                if (bufLength == 0) {
                    long l2 = 0L;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, l2);
                        ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, null);
                    }
                    return 0L;
                }
                if (repOffset == true && bufLength > 2 || repOffset == 2 && bufLength > 4) {
                    if (bl) {
                        this.debug($$$loggerRef$$$45, Level.FINEST, $$$methodRef$$$45, "T4CMAREngine.buffer2Value: incorrect number of bytes");
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 412).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, sQLException);
                    }
                    throw sQLException;
                }
            } else if (repOffset == true) {
                bufLength = 2;
            } else if (repOffset == 2) {
                bufLength = 4;
            }
            if (in.read(tmpBuffer = new byte[bufLength]) < 0) {
                if (bl) {
                    this.debug($$$loggerRef$$$45, Level.FINEST, $$$methodRef$$$45, "T4CMAREngine.buffer2Value: end of buffer");
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, sQLException);
                }
                throw sQLException;
            }
            for (int i2 = 0; i2 < tmpBuffer.length; ++i2) {
                short tmpByte = (this.types.rep[repOffset] & 2) > 0 ? (short)(tmpBuffer[tmpBuffer.length - 1 - i2] & 0xFF) : (short)(tmpBuffer[i2] & 0xFF);
                value |= (long)(tmpByte << 8 * (tmpBuffer.length - 1 - i2));
            }
            value &= 0xFFFFFFFFFFFFFFFFL;
            if (negative) {
                value = -value;
            }
            long l3 = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, l3);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$46, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.connForException.get();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$46, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$46, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setConnectionDuringExceptionHandling(OracleConnection oracleConnection) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$47, this, oracleConnection);
            }
            this.connForException.set((OracleConnection)conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$47, this);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$47, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    protected abstract void flush() throws IOException;

    abstract void setByteOrder(byte var1) throws IOException;

    abstract void writeZeroCopyIO(byte[] var1, int var2, int var3) throws IOException, NetException;

    /*
     * WARNING - void declaration
     */
    void writeZeroCopyIO(DynamicByteArray dynamicByteArray, long l2, int n2) throws IOException, NetException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void offset;
            void dba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$48, this, dynamicByteArray, l2, n2);
            }
            dba.writeZeroCopyIO(this, (long)offset, (int)length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$48, this);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$48, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract void writeZeroCopyIOHeader(boolean var1, int var2, boolean var3) throws IOException, NetException;

    abstract void writeZeroCopyIOData(byte[] var1, int var2, int var3) throws IOException, NetException;

    /*
     * WARNING - void declaration
     */
    boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException, NetException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void bytesRead;
            void offset;
            void userBuffer;
            boolean isMarked;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$49, this, byArray, n2, nArray);
            }
            boolean bl2 = isMarked = this.net.readZeroCopyIO((byte[])userBuffer, (int)offset, (int[])bytesRead);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$49, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$49, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setUseCLRBigChunks(boolean bl) {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void useCLRBigChunks;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$50, this, bl);
            }
            this.useCLRBigChunks = useCLRBigChunks;
            if (useCLRBigChunks == true) {
                this.effectiveTTCC_MXIN = Short.MAX_VALUE;
            } else {
                if (!$assertionsDisabled) {
                    AssertionError assertionError = new AssertionError();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$50, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$50, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                this.effectiveTTCC_MXIN = 64;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$50, this);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$50, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, T4CMAREngine.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract void clearWriteBuffer();

    abstract void prepareForUnmarshalAsync(Consumer<Throwable> var1) throws IOException;

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$51 = T4CMAREngine.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = T4CMAREngine.class.getDeclaredMethod("setUseCLRBigChunks", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = T4CMAREngine.class.getDeclaredMethod("readZeroCopyIO", byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = T4CMAREngine.class.getDeclaredMethod("writeZeroCopyIO", DynamicByteArray.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = T4CMAREngine.class.getDeclaredMethod("setConnectionDuringExceptionHandling", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = T4CMAREngine.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = T4CMAREngine.class.getDeclaredMethod("buffer2Value", Byte.TYPE, ByteArrayInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = T4CMAREngine.class.getDeclaredMethod("unmarshalDALC", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = T4CMAREngine.class.getDeclaredMethod("unmarshalDALC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = T4CMAREngine.class.getDeclaredMethod("unmarshalDALC", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = T4CMAREngine.class.getDeclaredMethod("processIndicator", Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = T4CMAREngine.class.getDeclaredMethod("escapeSequenceNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLRforREFS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = T4CMAREngine.class.getDeclaredMethod("unmarshalBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = T4CMAREngine.class.getDeclaredMethod("unmarshalKEYVAL", byte[][].class, byte[][].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", byte[].class, Integer.TYPE, int[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", byte[].class, Integer.TYPE, int[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = T4CMAREngine.class.getDeclaredMethod("unmarshalCHR", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CMAREngine.class.getDeclaredMethod("unmarshalUWORD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CMAREngine.class.getDeclaredMethod("unmarshalSWORD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CMAREngine.class.getDeclaredMethod("unmarshalRefCursor", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CMAREngine.class.getDeclaredMethod("unmarshalSB8", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CMAREngine.class.getDeclaredMethod("unmarshalSB4", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CMAREngine.class.getDeclaredMethod("unmarshalUCS2", byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CMAREngine.class.getDeclaredMethod("unmarshalNativeUB2", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CMAREngine.class.getDeclaredMethod("addPtr", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CMAREngine.class.getDeclaredMethod("unmarshalKPDKV", byte[][].class, int[].class, byte[][].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CMAREngine.class.getDeclaredMethod("marshalKPDKV", byte[][].class, byte[][].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CMAREngine.class.getDeclaredMethod("marshalDALC", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CMAREngine.class.getDeclaredMethod("marshalKEYVAL", byte[][].class, byte[][].class, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CMAREngine.class.getDeclaredMethod("marshalKEYVAL", byte[][].class, int[].class, byte[][].class, int[].class, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CMAREngine.class.getDeclaredMethod("marshalCLR", InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CMAREngine.class.getDeclaredMethod("marshalCLR", DynamicByteArray.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CMAREngine.class.getDeclaredMethod("marshalCLR", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CMAREngine.class.getDeclaredMethod("marshalCLR", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CMAREngine.class.getDeclaredMethod("marshalCHR", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CMAREngine.class.getDeclaredMethod("marshalCHR", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CMAREngine.class.getDeclaredMethod("marshalPTR", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CMAREngine.class.getDeclaredMethod("marshalNULLPTR", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CMAREngine.class.getDeclaredMethod("marshalO2U", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CMAREngine.class.getDeclaredMethod("marshalUB4Array", long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CMAREngine.class.getDeclaredMethod("marshalUWORD", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CMAREngine.class.getDeclaredMethod("marshalSWORD", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CMAREngine.class.getDeclaredMethod("toHex", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CMAREngine.class.getDeclaredMethod("toHex", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CMAREngine.class.getDeclaredMethod("toHex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CMAREngine.class.getDeclaredMethod("toHex", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CMAREngine.class.getDeclaredMethod("toHex", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CMAREngine.class.getDeclaredMethod("toHex", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_BYTES = new byte[0];
        IGNORED = new byte[Short.MAX_VALUE];
        NULL_PTR = new byte[]{0, 0, 0, 0};
        NOTNULL_PTR = new byte[]{127, 127, 127, 127};
    }
}

