/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONNECT})
class PropertiesFileUtil {
    private static final String DEFAULT_FILE_NAME = "ojdbc.properties";
    private static final String ALIAS_FILE_PREFIX = "ojdbc_";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String DEFAULT_PATH_LIST_ENTRY = "default";
    private static final String[] DEFAULT_PATH_LIST;
    private static final String FILE_SCHEME = "file://";
    private static final String PREFIXED_CONNECTION_PROPERTY_DATABASE = "oracle.jdbc.database";
    private static final int MAX_PATH_LENGTH = 40000;
    private static final String MAX_PATH_LENGTH_MSG = "File path is too long";
    private static final int MAX_FILES = 20;
    private static final String MAX_FILES_MSG = "Too many files";
    private static final int MAX_FILE_SIZE = 1000000;
    private static final String MAX_FILE_SIZE_MSG = "File is too large";
    private static final String NULL_CHARACTER_PATH_MSG = "Path contains the null character";
    private static final String DOES_NOT_EXIST_MSG = "File does not exist";
    private static final String NOT_REGULAR_MSG = "Not a regular file";
    private static final Pattern VALID_TNS_ALIAS;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    private PropertiesFileUtil() {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$14, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind(value=PropertiesBlinder.class)
    static Properties loadPropertiesFromFile(String string, String string2, boolean bl, String string3, boolean bl2) throws SQLException {
        boolean bl3 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String[] filePaths;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$0, null, string, string2, bl, string3, bl2);
            }
            Properties result = null;
            try {
                String configFileProperty;
                filePaths = PropertiesFileUtil.getFileList(configFileProperty);
            }
            catch (IOException ioEx) {
                SQLException sqlEx = DatabaseError.createSqlException(1700);
                sqlEx.initCause(ioEx).fillInStackTrace();
                SQLException sQLException = sqlEx;
                if (bl3) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$0, null, sQLException);
                }
                throw sQLException;
            }
            int i2 = filePaths.length;
            while (i2 > 0) {
                void fileOverridesTnsAdmin;
                String tnsAdmin;
                String filePath;
                if ((filePath = filePaths[--i2].trim()).isEmpty()) continue;
                try {
                    void fileOverridesConnectIdentifier;
                    void connectIdentifier;
                    result = filePath.equals(DEFAULT_PATH_LIST_ENTRY) ? PropertiesFileUtil.loadDefaultFiles(tnsAdmin, (String)connectIdentifier, (boolean)fileOverridesConnectIdentifier, result) : PropertiesFileUtil.loadUserFile(filePath, tnsAdmin, result);
                }
                catch (IOException ioEx) {
                    SQLException sqlEx = DatabaseError.createSqlException(1700, filePath);
                    sqlEx.initCause(ioEx).fillInStackTrace();
                    SQLException sQLException = sqlEx;
                    if (bl3) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$0, null, sQLException);
                    }
                    throw sQLException;
                }
                if (fileOverridesTnsAdmin == false && tnsAdmin != null || result == null) continue;
                tnsAdmin = result.getProperty("oracle.net.tns_admin", tnsAdmin);
            }
            Properties properties = result;
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$0, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$0, null, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final String[] getFileList(String string) throws IOException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String[] filePaths;
            String configFileProperty;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$1, null, string);
            }
            if (configFileProperty == null) {
                filePaths = DEFAULT_PATH_LIST;
            } else {
                if (configFileProperty.length() > 40000) {
                    IOException iOException = new IOException(MAX_PATH_LENGTH_MSG);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$1, null, iOException);
                    }
                    throw iOException;
                }
                filePaths = configFileProperty.split(",");
                if (filePaths.length > 20) {
                    IOException iOException = new IOException(MAX_FILES_MSG);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$1, null, iOException);
                    }
                    throw iOException;
                }
            }
            String[] stringArray = filePaths;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$1, null, stringArray);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$1, null, null);
            }
            return filePaths;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind(value=PropertiesBlinder.class)
    private static Properties loadDefaultFiles(String string, String string2, boolean bl, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException, IOException {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            Properties result;
            String tnsAdmin;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$2, null, string, string2, bl, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            Properties defaultProperties = null;
            if (tnsAdmin != null && !(tnsAdmin = tnsAdmin.trim()).isEmpty()) {
                String connectIdentifier;
                void fileOverridesConnectIdentifier;
                Path defaultPath = PropertiesFileUtil.validatePath(false, tnsAdmin, DEFAULT_FILE_NAME);
                if (defaultPath == null) {
                    if (bl2) {
                        PropertiesFileUtil.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "The driver will not attempt to read from ojdbc.properties due to a failed vaidation check.");
                    }
                } else {
                    defaultProperties = PropertiesFileUtil.loadProperties(false, defaultPath);
                    if (defaultProperties != null) {
                        PropertiesFileUtil.filterTnsAdmin(defaultProperties, DEFAULT_FILE_NAME);
                        PropertiesFileUtil.processExpressions(defaultProperties, tnsAdmin);
                    }
                }
                if (fileOverridesConnectIdentifier != false || connectIdentifier == null) {
                    connectIdentifier = PropertiesFileUtil.resolveConnectIdentifier(result, defaultProperties, connectIdentifier);
                }
                result = PropertiesFileUtil.loadAliasedFile(tnsAdmin, connectIdentifier, result);
            }
            Properties properties2 = PropertiesFileUtil.mergeProperties(result, defaultProperties);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$2, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$2, null, null);
            }
            return properties2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind(value=PropertiesBlinder.class)
    private static Properties loadAliasedFile(String string, String string2, @Blind(value=PropertiesBlinder.class) Properties properties) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            String connectIdentifier;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$3, null, string, string2, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            Properties aliasedProperties = null;
            if (connectIdentifier != null && !(connectIdentifier = connectIdentifier.trim()).isEmpty()) {
                if (connectIdentifier.length() > 40000) {
                    if (bl) {
                        PropertiesFileUtil.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "The driver will not attempt to read from an aliased properties file. The connect identifier is too long.");
                    }
                } else if (!VALID_TNS_ALIAS.matcher(connectIdentifier).matches()) {
                    if (bl) {
                        PropertiesFileUtil.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "The driver will not attempt to read from an aliased properties file. The connect identifier does not match a TNS alias syntax, where all characters belong to the set [a-z, A-Z, 0-9, _]");
                    }
                } else {
                    String tnsAdmin;
                    String alias = connectIdentifier;
                    Path aliasedPath = PropertiesFileUtil.validatePath(false, tnsAdmin, ALIAS_FILE_PREFIX + alias + PROPERTIES_EXTENSION);
                    if (aliasedPath == null) {
                        if (bl) {
                            PropertiesFileUtil.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "The driver will not attempt to read from ojdbc_<alias>.properties due to a failed validation check.");
                        }
                    } else {
                        aliasedProperties = PropertiesFileUtil.loadProperties(false, aliasedPath);
                        if (aliasedProperties != null) {
                            String fileName = aliasedPath.getFileName().toString();
                            PropertiesFileUtil.filterTnsAdmin(aliasedProperties, fileName);
                            PropertiesFileUtil.filterConnectIdentifier(aliasedProperties, fileName);
                            PropertiesFileUtil.processExpressions(aliasedProperties, tnsAdmin);
                        }
                    }
                }
            }
            Properties properties2 = PropertiesFileUtil.mergeProperties((Properties)result, aliasedProperties);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$3, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$3, null, null);
            }
            return properties2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind(value=PropertiesBlinder.class)
    private static Properties loadUserFile(String string, String string2, @Blind(value=PropertiesBlinder.class) Properties properties) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            void tnsAdmin;
            String filePath;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$4, null, string, string2, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            Path userPath = filePath.regionMatches(true, 0, FILE_SCHEME, 0, FILE_SCHEME.length()) ? PropertiesFileUtil.validateURI(filePath) : PropertiesFileUtil.validatePath(true, filePath, new String[0]);
            Properties userProperties = PropertiesFileUtil.loadProperties(true, userPath);
            PropertiesFileUtil.processExpressions(userProperties, (String)tnsAdmin);
            Properties properties2 = PropertiesFileUtil.mergeProperties((Properties)result, userProperties);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$4, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$4, null, null);
            }
            return properties2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Blind(value=PropertiesBlinder.class)
    private static Properties loadProperties(boolean var0, Path var1_1) throws IOException {
        var9_2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (var9_2) {
                ClioSupport.entering(PropertiesFileUtil.$$$loggerRef$$$5, Level.FINEST, PropertiesFileUtil.class, PropertiesFileUtil.$$$methodRef$$$5, null, new Object[]{var0, var1_1});
            }
            if (!PropertiesFileUtil.validateFile(errorIfInvalid, (Path)path)) {
                v0 = var10_3 = null;
                if (var9_2 == false) return v0;
            }
            ** GOTO lbl19
            {
                catch (IllegalArgumentException badFormat) {
                    var11_14 = new IOException(badFormat);
                    if (var9_2 == false) throw var11_14;
                    ClioSupport.throwing(PropertiesFileUtil.$$$loggerRef$$$5, Level.FINEST, PropertiesFileUtil.class, PropertiesFileUtil.$$$methodRef$$$5, null, var11_14);
                    throw var11_14;
                }
                ClioSupport.returning(PropertiesFileUtil.$$$loggerRef$$$5, Level.FINEST, PropertiesFileUtil.class, PropertiesFileUtil.$$$methodRef$$$5, null, TraceControllerImpl.blind(PropertiesBlinder.class, var10_3));
                ClioSupport.exiting(PropertiesFileUtil.$$$loggerRef$$$5, Level.FINEST, PropertiesFileUtil.class, PropertiesFileUtil.$$$methodRef$$$5, null, null);
                return v0;
lbl19:
                // 1 sources

                inStream = Files.newInputStream((Path)path, new OpenOption[0]);
                var3_7 = null;
                try {
                    properties = new Properties();
                    properties.load(inStream);
                    var5_10 = properties;
                    return var5_10;
                }
                catch (Throwable var4_9) {}
lbl26:
                // 3 sources

                while (true) {
                    var10_4 = var5_10;
                    if (var9_2 == false) return var10_4;
                    ClioSupport.returning(PropertiesFileUtil.$$$loggerRef$$$5, Level.FINEST, PropertiesFileUtil.class, PropertiesFileUtil.$$$methodRef$$$5, null, TraceControllerImpl.blind(PropertiesBlinder.class, var10_4));
                    ClioSupport.exiting(PropertiesFileUtil.$$$loggerRef$$$5, Level.FINEST, PropertiesFileUtil.class, PropertiesFileUtil.$$$methodRef$$$5, null, null);
                    return var10_4;
                }
                {
                    var3_7 = var4_9;
                    var11_12 = var4_9;
                    if (var9_2 == false) throw var11_12;
                    ClioSupport.throwing(PropertiesFileUtil.$$$loggerRef$$$5, Level.FINEST, PropertiesFileUtil.class, PropertiesFileUtil.$$$methodRef$$$5, null, var11_12);
                    throw var11_12;
                }
            }
            finally {
                if (inStream == null) ** GOTO lbl26
                if (var3_7 == null) {
                    inStream.close();
                }
                try {
                    inStream.close();
                }
                catch (Throwable var6_11) {
                    var3_7.addSuppressed(var6_11);
                }
                ** continue;
            }
        }
        catch (Throwable v1) {
            var11_15 = v1;
            if (var9_2 == false) throw v1;
            ClioSupport.exiting(PropertiesFileUtil.$$$loggerRef$$$5, Level.FINEST, PropertiesFileUtil.class, PropertiesFileUtil.$$$methodRef$$$5, null, var11_15);
            throw v1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateFile(boolean bl, Path path) throws IOException {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            boolean throwError;
            void path2;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$6, null, bl, path);
            }
            IOException err = null;
            if (!Files.exists((Path)path2, new LinkOption[0])) {
                err = new IOException(DOES_NOT_EXIST_MSG);
            } else if (!Files.isRegularFile((Path)path2, new LinkOption[0])) {
                err = new IOException(NOT_REGULAR_MSG);
            } else if (Files.size((Path)path2) > 1000000L) {
                err = new IOException(MAX_FILE_SIZE_MSG);
            }
            if (err == null) {
                boolean bl3 = true;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$6, null, bl3);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$6, null, null);
                }
                return true;
            }
            if (throwError) {
                IOException iOException = err;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$6, null, iOException);
                }
                throw iOException;
            }
            if (bl2) {
                PropertiesFileUtil.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "The driver will not load properties from " + path2.getFileName() + " due to a failed validation check: " + err.getMessage());
            }
            boolean bl4 = false;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$6, null, bl4);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$6, null, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Path validatePath(boolean bl, String string, String ... stringArray) throws IOException {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            boolean throwError;
            void more;
            void first;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$7, null, bl, string, stringArray);
            }
            IOException err = null;
            Object current = first;
            int next = 0;
            int totalLength = 0;
            while (err == null && current != null) {
                if (((String)current).indexOf(0) >= 0) {
                    err = new IOException(NULL_CHARACTER_PATH_MSG);
                    break;
                }
                if ((totalLength += ((String)current).length()) > 40000) {
                    err = new IOException(MAX_PATH_LENGTH_MSG);
                    break;
                }
                current = more != null && next < ((void)more).length ? more[next++] : null;
            }
            if (err == null) {
                Path path = Paths.get((String)first, (String[])more);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$7, null, path);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$7, null, null);
                }
                return path;
            }
            if (throwError) {
                IOException iOException = err;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$7, null, iOException);
                }
                throw iOException;
            }
            if (bl2) {
                PropertiesFileUtil.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "The driver will not load properties from a file due to a failed validation check: " + err.getMessage());
            }
            Path path = null;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$7, null, path);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$7, null, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    private static Path validateURI(String string) throws IOException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String uriString;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$8, null, string);
            }
            if (uriString.indexOf(0) >= 0) {
                IOException iOException = new IOException(NULL_CHARACTER_PATH_MSG);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$8, null, iOException);
                }
                throw iOException;
            }
            if (uriString.length() > 40000) {
                IOException iOException = new IOException(MAX_PATH_LENGTH_MSG);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$8, null, iOException);
                }
                throw iOException;
            }
            Path path = Paths.get(URI.create(uriString));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$8, null, path);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$8, null, null);
            }
            return path;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind(value=PropertiesBlinder.class)
    private static Properties mergeProperties(@Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            Properties from;
            void into;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$9, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties), TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
            }
            if (into == null) {
                Properties properties3 = from;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$9, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties3));
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$9, null, null);
                }
                return properties3;
            }
            if (from == null) {
                void var3_4 = into;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$9, null, TraceControllerImpl.blind(PropertiesBlinder.class, var3_4));
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$9, null, null);
                }
                return var3_4;
            }
            into.putAll((Map<?, ?>)from);
            void var3_5 = into;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$9, null, TraceControllerImpl.blind(PropertiesBlinder.class, var3_5));
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$9, null, null);
            }
            return var3_5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void filterTnsAdmin(@Blind(value=PropertiesBlinder.class) Properties properties, String string) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            Properties input;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$10, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string);
            }
            if (null != input.remove("oracle.net.tns_admin") && bl) {
                void fileName;
                PropertiesFileUtil.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "Ignoring the value of oracle.net.tns_admin defined in " + (String)fileName + "; A TNS Admin directory was already recognized in order to read the file.");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void filterConnectIdentifier(@Blind(value=PropertiesBlinder.class) Properties properties, String string) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void fileName;
            Properties input;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$11, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string);
            }
            if (null != input.remove("database") && bl) {
                PropertiesFileUtil.debug($$$loggerRef$$$11, Level.FINEST, $$$methodRef$$$11, "Ignoring the value of database defined in " + (String)fileName + ". A connect identifier was already recognized in order to read the file.");
            }
            if (null != input.remove(PREFIXED_CONNECTION_PROPERTY_DATABASE) && bl) {
                PropertiesFileUtil.debug($$$loggerRef$$$11, Level.FINEST, $$$methodRef$$$11, "Ignoring the value of oracle.jdbc.database defined in " + (String)fileName + ". A connect identifier was already recognized in order to read the file.");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String resolveConnectIdentifier(@Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2, String string) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void defaultValue;
            String string2;
            void ojdbcProperties;
            Properties result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$12, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties), TraceControllerImpl.blind(PropertiesBlinder.class, properties2), string);
            }
            String connectIdentifier = null;
            if (result != null && (connectIdentifier = result.getProperty("database")) == null) {
                connectIdentifier = result.getProperty(PREFIXED_CONNECTION_PROPERTY_DATABASE);
            }
            if (connectIdentifier == null && ojdbcProperties != null && (connectIdentifier = ojdbcProperties.getProperty("database")) == null) {
                connectIdentifier = ojdbcProperties.getProperty(PREFIXED_CONNECTION_PROPERTY_DATABASE);
            }
            Object object = string2 = connectIdentifier == null ? defaultValue : connectIdentifier;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$12, null, string2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$12, null, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void processExpressions(@Blind(value=PropertiesBlinder.class) Properties properties, String string) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            Properties loadedFromFile;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$13, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string);
            }
            if (loadedFromFile == null || loadedFromFile.isEmpty()) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$13, null);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$13, null, null);
                }
                return;
            }
            Set<String> stringKeys = loadedFromFile.stringPropertyNames();
            String[] sortedKeys = new String[stringKeys.size()];
            Arrays.sort(stringKeys.toArray(sortedKeys));
            for (String key : sortedKeys) {
                String value = loadedFromFile.getProperty(key);
                try {
                    void tnsAdmin;
                    loadedFromFile.setProperty(key, Interpreter.interpret(value, (String)tnsAdmin));
                }
                catch (Exception ex) {
                    SQLException sqlEx = DatabaseError.createSqlException(1701, key);
                    sqlEx.initCause(ex).fillInStackTrace();
                    SQLException sQLException = sqlEx;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$13, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, PropertiesFileUtil.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    private static void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, PropertiesFileUtil.class, method, msg);
    }

    static {
        try {
            $$$methodRef$$$14 = PropertiesFileUtil.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = PropertiesFileUtil.class.getDeclaredMethod("processExpressions", Properties.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = PropertiesFileUtil.class.getDeclaredMethod("resolveConnectIdentifier", Properties.class, Properties.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = PropertiesFileUtil.class.getDeclaredMethod("filterConnectIdentifier", Properties.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = PropertiesFileUtil.class.getDeclaredMethod("filterTnsAdmin", Properties.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = PropertiesFileUtil.class.getDeclaredMethod("mergeProperties", Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = PropertiesFileUtil.class.getDeclaredMethod("validateURI", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = PropertiesFileUtil.class.getDeclaredMethod("validatePath", Boolean.TYPE, String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = PropertiesFileUtil.class.getDeclaredMethod("validateFile", Boolean.TYPE, Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = PropertiesFileUtil.class.getDeclaredMethod("loadProperties", Boolean.TYPE, Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = PropertiesFileUtil.class.getDeclaredMethod("loadUserFile", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = PropertiesFileUtil.class.getDeclaredMethod("loadAliasedFile", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = PropertiesFileUtil.class.getDeclaredMethod("loadDefaultFiles", String.class, String.class, Boolean.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = PropertiesFileUtil.class.getDeclaredMethod("getFileList", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = PropertiesFileUtil.class.getDeclaredMethod("loadPropertiesFromFile", String.class, String.class, Boolean.TYPE, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        DEFAULT_PATH_LIST = new String[]{DEFAULT_PATH_LIST_ENTRY};
        VALID_TNS_ALIAS = Pattern.compile("\\w+");
    }

    private static class Interpreter {
        private static final char DOLLAR = '$';
        private static final char QUESTION_MARK = '?';
        private static final char OPEN_BRACE = '{';
        private static final char CLOSE_BRACE = '}';
        private static final String FILE_SEPERATOR_PROPERTY = "/";
        private static final String ORACLE_HOME = "ORACLE_HOME";
        private static final Object TNS_ADMIN;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        private Interpreter() {
        }

        private static String interpret(String input, String tnsAdmin) throws IOException {
            StringBuilder output = new StringBuilder(input.length());
            int pos = 0;
            block4: while (pos < input.length()) {
                char next = input.charAt(pos);
                switch (next) {
                    case '$': {
                        pos = Interpreter.readDollar(input, pos + 1, output, tnsAdmin);
                        continue block4;
                    }
                    case '?': {
                        pos = Interpreter.readQuestionMark(input, pos + 1, output);
                        continue block4;
                    }
                }
                output.append(next);
                ++pos;
            }
            return output.toString();
        }

        private static int readQuestionMark(String input, int pos, StringBuilder output) throws IOException {
            if (pos < input.length() && '?' == input.charAt(pos)) {
                output.append('?');
                return pos + 1;
            }
            String value = System.getenv(ORACLE_HOME);
            if (value == null) {
                throw new IOException("Environment variable is not set: ORACLE_HOME. ('?' is interpreted as $ORACLE_HOME)");
            }
            output.append(value);
            return pos;
        }

        private static int readDollar(String input, int pos, StringBuilder output, String tnsAdmin) throws IOException {
            if (pos == input.length()) {
                output.append('$');
                return pos;
            }
            char next = input.charAt(pos);
            switch (next) {
                case '{': {
                    return Interpreter.readDollarExpression(input, pos + 1, output, tnsAdmin);
                }
                case '$': {
                    output.append('$');
                    return pos + 1;
                }
            }
            output.append('$');
            output.append(next);
            return pos + 1;
        }

        private static int readDollarExpression(String input, int pos, StringBuilder output, String tnsAdmin) throws IOException {
            String value;
            int end = input.indexOf(125, pos);
            if (end == pos) {
                throw new IOException("${identifier} expression has a zero length identifier");
            }
            if (end == -1) {
                throw new IOException("${identifier} expression is missing a closing brace");
            }
            String name = input.substring(pos, end);
            if (name.equals(FILE_SEPERATOR_PROPERTY)) {
                value = File.separator;
            } else if (name.equals(TNS_ADMIN)) {
                value = tnsAdmin;
            } else {
                value = System.getProperty(name);
                if (value == null) {
                    value = System.getenv(name);
                }
            }
            if (value == null) {
                throw new IOException(name + " is not defined as a system property or environment variable");
            }
            output.append(value);
            return end + 1;
        }

        static {
            try {
                $$$methodRef$$$5 = Interpreter.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Interpreter.class.getDeclaredMethod("access$000", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Interpreter.class.getDeclaredMethod("readDollarExpression", String.class, Integer.TYPE, StringBuilder.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Interpreter.class.getDeclaredMethod("readDollar", String.class, Integer.TYPE, StringBuilder.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Interpreter.class.getDeclaredMethod("readQuestionMark", String.class, Integer.TYPE, StringBuilder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Interpreter.class.getDeclaredMethod("interpret", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            TNS_ADMIN = "TNS_ADMIN";
        }
    }
}

