/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvRecordFormatForm;
import com.intellij.database.data.types.BaseConversionGraph;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridNotifications;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.actions.ChoosePasteFormatAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.GridTransferableData;
import com.intellij.ide.PasteProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridPasteProvider
implements PasteProvider {
    private static final Logger LOG = Logger.getInstance(GridPasteProvider.class);
    private final DataGrid myGrid;
    private final TableDataParser myTableDataParser;

    public GridPasteProvider(@NotNull DataGrid grid, @Nullable TableDataParser tableDataParser) {
        if (grid == null) {
            GridPasteProvider.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
        this.myTableDataParser = tableDataParser;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            GridPasteProvider.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Notification notification;
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(2);
        }
        @NotNull Project project = this.myGrid.getProject();
        Object contents = CopyPasteManager.getInstance().getContents(GridTransferableData.ourFlavor);
        GridTransferableData data = null;
        ChoosePasteFormatAction.PasteType pasteType = null;
        CsvFormat csvFormat = null;
        if (contents instanceof GridTransferableData) {
            GridTransferableData d;
            data = d = (GridTransferableData)contents;
        } else {
            contents = CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
            if (contents instanceof String) {
                String text = (String)contents;
                TableDataParseResult result = this.myTableDataParser == null ? null : this.myTableDataParser.retrieveDataFromText(project, text, this.myGrid);
                data = result == null ? null : result.myData;
                pasteType = result == null ? null : result.myPasteType;
                CsvFormat csvFormat2 = csvFormat = result == null ? null : result.myFormat;
            }
        }
        if (data == null) {
            return;
        }
        SelectionModel model2 = this.myGrid.getSelectionModel();
        ModelIndexSet rows = model2.getSelectedRows();
        ModelIndexSet columns = model2.getSelectedColumns();
        data = GridPasteProvider.adjustDataToSelection(data, rows.size(), true);
        data = GridPasteProvider.adjustDataToSelection(data, columns.size(), false);
        int minRow = Math.max(0, GridUtil.min(rows.toView((CoreGrid)this.myGrid)));
        int maxRow = minRow + data.getRowsCount() - 1;
        int minCol = Math.max(0, GridUtil.min(columns.toView((CoreGrid)this.myGrid)));
        int rowOffset = minRow - data.getFirstRowIdx();
        int colOffset = minCol - data.getFirstColumnIdx();
        int count = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount();
        GridUtil.addRows(this.myGrid, Math.max(0, maxRow - count + 1));
        ArrayList conversionExceptions = new ArrayList();
        List conversions = JBIterable.from((Iterable)data.getConversions()).map(conversion -> conversion.copy().secondGrid((CoreGrid)this.myGrid).offset(rowOffset, colOffset).build()).filter(DataTypeConversion::isValid).map(c2 -> {
            try {
                return GridHelper.get(this.myGrid).isMixedTypeColumns(this.myGrid) ? c2.build() : c2.convert(BaseConversionGraph.get((CoreGrid)this.myGrid));
            }
            catch (Exception e) {
                conversionExceptions.add(e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
        this.myGrid.getDataSupport().finishBuildingAndApply(conversions);
        if (!conversionExceptions.isEmpty()) {
            String error = conversionExceptions.size() == 1 ? ((Exception)conversionExceptions.get(0)).getMessage() : DataGridBundle.message((String)"group.Console.TableResult.PasteError.multiple.text", (Object[])new Object[]{conversionExceptions.size()});
            Notification errorNotification = DataGridNotifications.PASTE_GROUP.createNotification(DataGridBundle.message((String)"group.Console.TableResult.PasteError.title", (Object[])new Object[0]), error, NotificationType.ERROR);
            errorNotification.notify(this.myGrid.getProject());
        } else if (pasteType != null && (notification = GridPasteProvider.createNotification(pasteType, csvFormat)) != null) {
            notification.addAction((AnAction)new ChoosePasteFormatAction(DataGridBundle.message((String)"group.Console.TableResult.PasteFormat.change.paste.format", (Object[])new Object[0]))).notify(this.myGrid.getProject());
        }
    }

    @Nullable
    private static Notification createNotification(@NotNull ChoosePasteFormatAction.PasteType pasteType, @Nullable CsvFormat csvFormat) {
        if (pasteType == null) {
            GridPasteProvider.$$$reportNull$$$0(3);
        }
        if (pasteType == ChoosePasteFormatAction.PasteType.SINGLE_VALUE) {
            return DataGridNotifications.PASTE_GROUP.createNotification(DataGridBundle.message((String)"table.data.pasted", (Object[])new Object[0]), DataGridBundle.message((String)"table.data.text.pasted.as.single.value", (Object[])new Object[0]), NotificationType.INFORMATION);
        }
        if (pasteType == ChoosePasteFormatAction.PasteType.FORMAT) {
            if (csvFormat == null) {
                LOG.error("Paste type is FORMAT but csv format is null.");
                return null;
            }
            return DataGridNotifications.PASTE_GROUP.createNotification(DataGridBundle.message((String)"table.data.pasted", (Object[])new Object[0]), DataGridBundle.message((String)"table.text.pasted.using.format", (Object[])new Object[]{csvFormat.name, GridPasteProvider.getDelimiterName(csvFormat)}), NotificationType.INFORMATION);
        }
        if (pasteType == ChoosePasteFormatAction.PasteType.AUTO) {
            if (csvFormat == null) {
                return DataGridNotifications.PASTE_GROUP.createNotification(DataGridBundle.message((String)"table.data.pasted", (Object[])new Object[0]), DataGridBundle.message((String)"table.data.no.format.detected", (Object[])new Object[0]), NotificationType.INFORMATION);
            }
            return DataGridNotifications.PASTE_GROUP.createNotification(DataGridBundle.message((String)"table.data.pasted", (Object[])new Object[0]), DataGridBundle.message((String)"table.data.format.detected", (Object[])new Object[]{csvFormat.name, GridPasteProvider.getDelimiterName(csvFormat)}), NotificationType.INFORMATION);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public static String getDelimiterName(@NotNull CsvFormat format) {
        if (format == null) {
            GridPasteProvider.$$$reportNull$$$0(4);
        }
        return GridPasteProvider.getDelimiterName(format.dataRecord.valueSeparator);
    }

    @NotNull
    @NlsSafe
    public static String getDelimiterName(@NotNull String delimiter) {
        CsvRecordFormatForm.LazyPair pair;
        if (delimiter == null) {
            GridPasteProvider.$$$reportNull$$$0(5);
        }
        Object object = (pair = (CsvRecordFormatForm.LazyPair)ContainerUtil.find(CsvRecordFormatForm.DELIMITERS, d -> ((String)d.value).equals(delimiter))) != null ? (pair.uiNameLowercase != null ? pair.uiNameLowercase.get() : pair.uiName.get()) : "'" + delimiter + "'";
        if (object == null) {
            GridPasteProvider.$$$reportNull$$$0(6);
        }
        return object;
    }

    @NotNull
    private static GridTransferableData adjustDataToSelection(@NotNull GridTransferableData data, int selectedCount, boolean isRow) {
        int dataCount;
        int duplicateCount;
        if (data == null) {
            GridPasteProvider.$$$reportNull$$$0(7);
        }
        if ((duplicateCount = selectedCount / (dataCount = isRow ? data.getRowsCount() : data.getColumnsCount())) <= 1) {
            GridTransferableData gridTransferableData = data;
            if (gridTransferableData == null) {
                GridPasteProvider.$$$reportNull$$$0(8);
            }
            return gridTransferableData;
        }
        ArrayList<DataTypeConversion.Builder> newConversions = new ArrayList<DataTypeConversion.Builder>(data.getConversions());
        for (int i = 1; i < duplicateCount; ++i) {
            for (DataTypeConversion.Builder conversion : data.getConversions()) {
                newConversions.add(isRow ? conversion.copy().firstRowIdx(conversion.firstRowIdx() + i * dataCount) : conversion.copy().firstColumnIdx(conversion.firstColumnIdx() + i * dataCount));
            }
        }
        return new GridTransferableData(newConversions, data.getTransferable(), data.getFirstRowIdx(), data.getFirstColumnIdx(), isRow ? dataCount * duplicateCount : dataCount);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(9);
        }
        CopyPasteManager manager = CopyPasteManager.getInstance();
        return this.isPasteEnabled(dataContext) && (manager.getContents(GridTransferableData.ourFlavor) instanceof GridTransferableData || manager.getContents(DataFlavor.stringFlavor) != null);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(10);
        }
        return this.myGrid.isReady() && this.myGrid.isEditable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridPasteProvider";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pasteType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridPasteProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDataToSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustDataToSelection";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 8 -> new IllegalStateException(string);
        };
    }

    public static interface TableDataParser {
        @NotNull
        public TableDataParseResult retrieveDataFromText(@NotNull Project var1, @NotNull String var2, @NotNull DataGrid var3);
    }

    public static class TableDataParseResult {
        public final GridTransferableData myData;
        public final ChoosePasteFormatAction.PasteType myPasteType;
        public final CsvFormat myFormat;

        public TableDataParseResult(@NotNull GridTransferableData data, @NotNull ChoosePasteFormatAction.PasteType type, @Nullable CsvFormat format) {
            if (data == null) {
                TableDataParseResult.$$$reportNull$$$0(0);
            }
            if (type == null) {
                TableDataParseResult.$$$reportNull$$$0(1);
            }
            this.myData = data;
            this.myPasteType = type;
            this.myFormat = format;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/grid/GridPasteProvider$TableDataParseResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

