/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutionInterceptor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ExecutorsQuery<Result, Parameter>
extends AbstractQuery<Result> {
    private static final Logger LOG = Logger.getInstance(ExecutorsQuery.class);
    private final List<? extends QueryExecutor<Result, Parameter>> executors;
    private final Parameter parameters;

    public ExecutorsQuery(@NotNull Parameter params, @NotNull List<? extends QueryExecutor<Result, Parameter>> executors) {
        if (params == null) {
            ExecutorsQuery.$$$reportNull$$$0(0);
        }
        if (executors == null) {
            ExecutorsQuery.$$$reportNull$$$0(1);
        }
        this.parameters = params;
        this.executors = executors;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super Result> consumer) {
        if (consumer == null) {
            ExecutorsQuery.$$$reportNull$$$0(2);
        }
        for (QueryExecutor<? super Result, Parameter> queryExecutor : this.executors) {
            try {
                ProgressManager.checkCanceled();
                if (queryExecutor.execute(this.parameters, consumer)) continue;
                return false;
            }
            catch (IndexNotReadyException indexNotReadyException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public Query<Result> interceptWith(@NotNull QueryExecutionInterceptor interceptor) {
        if (interceptor == null) {
            ExecutorsQuery.$$$reportNull$$$0(3);
        }
        if (this.executors.isEmpty()) {
            return new ExecutorsQuery<Result, Parameter>(this.parameters, Collections.emptyList());
        }
        ArrayList result = new ArrayList(this.executors.size());
        for (QueryExecutor executor : this.executors) {
            result.add((queryParameters, consumer) -> interceptor.intercept(() -> executor.execute(queryParameters, consumer)));
        }
        return new ExecutorsQuery<Result, Parameter>(this.parameters, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interceptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ExecutorsQuery";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processResults";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "interceptWith";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

