/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.assertion;

import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleMutableTree;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeAssertion;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeUtilKt;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.common.WaitUtilsKt;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001f\u0010\b\u001a\u001b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\b\fJ\"\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\tJ*\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\tJ*\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\tJ\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/platform/testFramework/assertion/BuildViewAssertions;", "", "<init>", "()V", "assertBuildViewTree", "", "buildView", "Lcom/intellij/build/BuildView;", "assert", "Lkotlin/Function1;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeAssertion$Node;", "", "Lkotlin/ExtensionFunctionType;", "assertBuildViewTreeText", "", "assertBuildViewNodeConsole", "nodeText", "Lcom/intellij/execution/ui/ExecutionConsole;", "assertBuildViewNodeConsoleText", "assertBuildViewNodeIsSelected", "getBuildViewTreeText", "showAllNodes", "treeView", "Lcom/intellij/build/BuildTreeConsoleView;", "getBuildViewTreeConsoleView", "getTreeNode", "Ljavax/swing/tree/TreeNode;", "tree", "Ljavax/swing/JTree;", "getTreeSelectedNode", "getTreeStringPresentation", "selectTreeNode", "intellij.platform.testFramework"})
public final class BuildViewAssertions {
    @NotNull
    public static final BuildViewAssertions INSTANCE = new BuildViewAssertions();

    private BuildViewAssertions() {
    }

    public final void assertBuildViewTree(@NotNull BuildView buildView, @NotNull Function1<? super SimpleTreeAssertion.Node, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)buildView, (String)"buildView");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        this.assertBuildViewTreeText(buildView, (Function1<? super String, Unit>)((Function1)arg_0 -> BuildViewAssertions.assertBuildViewTree$lambda$0(function1, arg_0)));
    }

    public final void assertBuildViewTreeText(@NotNull BuildView buildView, @NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)buildView, (String)"buildView");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        WaitUtilsKt.waitUntilAssertSucceedsBlocking-VtjQ1oo$default(0L, () -> BuildViewAssertions.assertBuildViewTreeText$lambda$0(function1, buildView), 1, null);
    }

    public final void assertBuildViewNodeConsole(@NotNull BuildView buildView, @NotNull String nodeText, @NotNull Function1<? super ExecutionConsole, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)buildView, (String)"buildView");
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        BuildTreeConsoleView treeConsoleView = this.getBuildViewTreeConsoleView(buildView);
        JTree jTree = treeConsoleView.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"getTree(...)");
        this.selectTreeNode(jTree, nodeText);
        WaitUtilsKt.waitUntilAssertSucceedsBlocking-VtjQ1oo$default(0L, () -> BuildViewAssertions.assertBuildViewNodeConsole$lambda$0(function1, treeConsoleView, nodeText), 1, null);
    }

    public final void assertBuildViewNodeConsoleText(@NotNull BuildView buildView, @NotNull String nodeText, @NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)buildView, (String)"buildView");
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        this.assertBuildViewNodeConsole(buildView, nodeText, (Function1<? super ExecutionConsole, Unit>)((Function1)arg_0 -> BuildViewAssertions.assertBuildViewNodeConsoleText$lambda$0(function1, arg_0)));
    }

    public final void assertBuildViewNodeIsSelected(@NotNull BuildView buildView, @NotNull String nodeText) {
        Intrinsics.checkNotNullParameter((Object)buildView, (String)"buildView");
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        BuildTreeConsoleView treeConsoleView = this.getBuildViewTreeConsoleView(buildView);
        JTree jTree = treeConsoleView.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"getTree(...)");
        TreeNode node = this.getTreeNode(jTree, nodeText);
        JTree jTree2 = treeConsoleView.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree2, (String)"getTree(...)");
        TreeNode selectedNode = this.getTreeSelectedNode(jTree2);
        if (!Intrinsics.areEqual((Object)node, (Object)selectedNode)) {
            Assertions.assertEquals((Object)node.toString(), (Object)selectedNode.toString());
        }
    }

    private final String getBuildViewTreeText(BuildView buildView) {
        BuildTreeConsoleView eventView = this.getBuildViewTreeConsoleView(buildView);
        JTree jTree = eventView.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"getTree(...)");
        return this.getTreeStringPresentation(jTree);
    }

    public final void showAllNodes(@NotNull BuildTreeConsoleView treeView) {
        Intrinsics.checkNotNullParameter((Object)treeView, (String)"treeView");
        treeView.addFilter(BuildTreeFilters.getSUCCESSFUL_STEPS_FILTER());
        treeView.addFilter(BuildTreeFilters.getWARNINGS_FILTER());
    }

    private final BuildTreeConsoleView getBuildViewTreeConsoleView(BuildView buildView) {
        Object object = buildView.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
        Intrinsics.checkNotNull((Object)object);
        BuildTreeConsoleView treeView = (BuildTreeConsoleView)object;
        this.showAllNodes(treeView);
        return treeView;
    }

    private final TreeNode getTreeNode(JTree tree, String nodeText) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)EdtTestUtilKt.runInEdtAndGet(() -> BuildViewAssertions.getTreeNode$lambda$0(tree, nodeText));
        Assertions.assertNotNull((Object)node, () -> BuildViewAssertions.getTreeNode$lambda$1(nodeText, tree));
        DefaultMutableTreeNode defaultMutableTreeNode = node;
        Intrinsics.checkNotNull((Object)defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    private final TreeNode getTreeSelectedNode(JTree tree) {
        TreePath treePath = tree.getSelectionPath();
        Intrinsics.checkNotNull((Object)treePath);
        Object object = treePath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object);
        return (TreeNode)object;
    }

    private final String getTreeStringPresentation(JTree tree) {
        Object v = EdtTestUtilKt.runInEdtAndGet(() -> BuildViewAssertions.getTreeStringPresentation$lambda$0(tree));
        Intrinsics.checkNotNullExpressionValue(v, (String)"runInEdtAndGet(...)");
        return (String)v;
    }

    private final void selectTreeNode(JTree tree, String nodeText) {
        TreeNode node = this.getTreeNode(tree, nodeText);
        EdtTestUtilKt.runInEdtAndGet(() -> BuildViewAssertions.selectTreeNode$lambda$0(tree, node));
    }

    private static final Unit assertBuildViewTree$lambda$0(Function1 $assert, String treeString) {
        Intrinsics.checkNotNullParameter((Object)treeString, (String)"treeString");
        SimpleMutableTree actualTree = SimpleTreeUtilKt.buildTree(treeString);
        SimpleTreeAssertion.Companion.assertTree(actualTree, arg_0 -> BuildViewAssertions.assertBuildViewTree$lambda$0$0($assert, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit assertBuildViewTree$lambda$0$0(Function1 $assert, SimpleTreeAssertion $this$assertTree) {
        Intrinsics.checkNotNullParameter((Object)$this$assertTree, (String)"$this$assertTree");
        SimpleTreeAssertion.assertNode$default($this$assertTree, "", false, false, false, $assert, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit assertBuildViewTreeText$lambda$0(Function1 $assert, BuildView $buildView) {
        $assert.invoke((Object)INSTANCE.getBuildViewTreeText($buildView));
        return Unit.INSTANCE;
    }

    private static final Unit assertBuildViewNodeConsole$lambda$0(Function1 $assert, BuildTreeConsoleView $treeConsoleView, String $nodeText) {
        ExecutionConsole nodeConsole = (ExecutionConsole)EdtTestUtilKt.runInEdtAndGet(() -> BuildViewAssertions.assertBuildViewNodeConsole$lambda$0$0($treeConsoleView));
        Assertions.assertNotNull((Object)nodeConsole, () -> BuildViewAssertions.assertBuildViewNodeConsole$lambda$0$1($nodeText, $treeConsoleView));
        ExecutionConsole executionConsole = nodeConsole;
        Intrinsics.checkNotNull((Object)executionConsole);
        $assert.invoke((Object)executionConsole);
        return Unit.INSTANCE;
    }

    private static final ExecutionConsole assertBuildViewNodeConsole$lambda$0$0(BuildTreeConsoleView $treeConsoleView) {
        PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
        return $treeConsoleView.getSelectedNodeConsole();
    }

    private static final String assertBuildViewNodeConsole$lambda$0$1(String $nodeText, BuildTreeConsoleView $treeConsoleView) {
        JTree jTree = $treeConsoleView.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"getTree(...)");
        return "Cannot find console of the '" + $nodeText + "' node in tree:\n" + INSTANCE.getTreeStringPresentation(jTree) + "\n";
    }

    private static final Unit assertBuildViewNodeConsoleText$lambda$0(Function1 $assert, ExecutionConsole it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $assert.invoke((Object)((ConsoleViewImpl)it).getText());
        return Unit.INSTANCE;
    }

    private static final DefaultMutableTreeNode getTreeNode$lambda$0(JTree $tree, String $nodeText) {
        PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
        PlatformTestUtil.waitWhileBusy($tree);
        Object object = $tree.getModel().getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        return TreeUtil.findNode((DefaultMutableTreeNode)((DefaultMutableTreeNode)object), arg_0 -> BuildViewAssertions.getTreeNode$lambda$0$1(arg_0 -> BuildViewAssertions.getTreeNode$lambda$0$0($nodeText, arg_0), arg_0));
    }

    private static final boolean getTreeNode$lambda$0$0(String $nodeText, DefaultMutableTreeNode it) {
        return Intrinsics.areEqual((Object)it.getUserObject().toString(), (Object)$nodeText);
    }

    private static final boolean getTreeNode$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String getTreeNode$lambda$1(String $nodeText, JTree $tree) {
        return "Cannot find the '" + $nodeText + "' node in tree:\n" + INSTANCE.getTreeStringPresentation($tree) + "\n";
    }

    private static final String getTreeStringPresentation$lambda$0(JTree $tree) {
        TreeUtil.expandAll((JTree)$tree);
        PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
        PlatformTestUtil.waitWhileBusy($tree);
        return PlatformTestUtil.print($tree, false);
    }

    private static final Unit selectTreeNode$lambda$0(JTree $tree, TreeNode $node) {
        TreeUtil.selectNode((JTree)$tree, (TreeNode)$node);
        PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
        PlatformTestUtil.waitWhileBusy($tree);
        return Unit.INSTANCE;
    }
}

