/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyStringConcatenationToFormatIntention
extends PsiUpdateModCommandAction<PyBinaryExpression> {
    PyStringConcatenationToFormatIntention() {
        super(PyBinaryExpression.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.string.concatenation.to.format", new Object[0]);
        if (string == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PyBinaryExpression element) {
        if (context == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(2);
        }
        if (!(context.file() instanceof PyFile)) {
            return null;
        }
        PyBinaryExpression topmostBinaryExpr = PyStringConcatenationToFormatIntention.getTopmostBinaryExpression(element);
        List<PyElementType> operators = PyStringConcatenationToFormatIntention.getOperators(topmostBinaryExpr);
        for (PyElementType operator : operators) {
            if (operator == PyTokenTypes.PLUS) continue;
            return null;
        }
        List<PyExpression> operands = PyStringConcatenationToFormatIntention.getOperands(topmostBinaryExpr);
        if (operands.isEmpty()) {
            return null;
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)element);
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis(context.project(), context.file());
        PyType stringType = PyBuiltinCache.getInstance((PsiElement)element).getStringType(languageLevel);
        for (PyExpression operand : operands) {
            PyType operandType;
            boolean isStringReference;
            if (operand == null) {
                return null;
            }
            if (operand instanceof PyStringLiteralExpression || (isStringReference = (operandType = typeEvalContext.getType(operand)) != null && PyTypeChecker.match(stringType, operandType, typeEvalContext))) continue;
            return null;
        }
        if (languageLevel.isAtLeast(LanguageLevel.PYTHON27)) {
            return Presentation.of((String)PyPsiBundle.message("INTN.replace.plus.with.str.format", new Object[0]));
        }
        return Presentation.of((String)PyPsiBundle.message("INTN.replace.plus.with.format.operator", new Object[0]));
    }

    protected void invoke(@NotNull ActionContext actionContext, @NotNull PyBinaryExpression element, @NotNull ModPsiUpdater updater) {
        if (actionContext == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(5);
        }
        PyBinaryExpression topmostBinaryExpr = PyStringConcatenationToFormatIntention.getTopmostBinaryExpression(element);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)topmostBinaryExpr);
        boolean useFormatMethod = languageLevel.isAtLeast(LanguageLevel.PYTHON27);
        NotNullFunction escaper = StringUtil.escaper((boolean)false, (String)"\"'\\");
        StringBuilder stringFormatExpr = new StringBuilder();
        ArrayList<String> parameters = new ArrayList<String>();
        Pair<String, String> quotes = Pair.create((Object)"\"", (Object)"\"");
        boolean quotesDetected = false;
        TypeEvalContext context = TypeEvalContext.userInitiated(actionContext.project(), actionContext.file());
        boolean isUnicode = false;
        PyClassTypeImpl unicodeType = PyBuiltinCache.getInstance((PsiElement)topmostBinaryExpr).getObjectType("unicode");
        for (PyExpression operand : PyStringConcatenationToFormatIntention.getOperands(topmostBinaryExpr)) {
            if (operand instanceof PyStringLiteralExpression) {
                PyStringLiteralExpression stringLiteralOperand = (PyStringLiteralExpression)operand;
                PyType type2 = context.getType(operand);
                if (type2 != null && type2.equals(unicodeType)) {
                    isUnicode = true;
                }
                if (!quotesDetected) {
                    quotes = PyStringLiteralCoreUtil.getQuotes(operand.getText());
                    quotesDetected = true;
                }
                String value = stringLiteralOperand.getStringValue();
                if (!useFormatMethod) {
                    value = value.replace("%", "%%");
                }
                stringFormatExpr.append((String)escaper.apply(value));
                continue;
            }
            PyStringConcatenationToFormatIntention.addParamToString(stringFormatExpr, parameters.size(), useFormatMethod);
            parameters.add(operand.getText());
        }
        if (quotes == null) {
            quotes = Pair.create((Object)"\"", (Object)"\"");
        }
        stringFormatExpr.insert(0, (String)quotes.getFirst());
        if (isUnicode && !StringUtil.toLowerCase((String)((String)quotes.getFirst())).contains("u")) {
            stringFormatExpr.insert(0, "u");
        }
        stringFormatExpr.append((String)quotes.getSecond());
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(actionContext.project());
        if (!parameters.isEmpty()) {
            if (useFormatMethod) {
                stringFormatExpr.append(".format(").append(StringUtil.join(parameters, (String)",")).append(")");
            } else {
                Object paramString = parameters.size() > 1 ? "(" + StringUtil.join(parameters, (String)",") + ")" : StringUtil.join(parameters, (String)",");
                stringFormatExpr.append(" % ").append((String)paramString);
            }
            topmostBinaryExpr.replace((PsiElement)elementGenerator.createExpressionFromText(languageLevel, stringFormatExpr.toString()));
        } else {
            topmostBinaryExpr.replace(elementGenerator.createStringLiteralAlreadyEscaped(stringFormatExpr.toString()));
        }
    }

    @NotNull
    private static PyBinaryExpression getTopmostBinaryExpression(@NotNull PyBinaryExpression element) {
        PsiElement psiElement;
        if (element == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(6);
        }
        PyBinaryExpression result2 = element;
        while ((psiElement = result2.getParent()) instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression;
            result2 = binaryExpression = (PyBinaryExpression)psiElement;
        }
        PyBinaryExpression pyBinaryExpression = result2;
        if (pyBinaryExpression == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(7);
        }
        return pyBinaryExpression;
    }

    @NotNull
    private static List<PyExpression> getOperands(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(8);
        }
        ArrayList<PyExpression> res = new ArrayList<PyExpression>();
        PyExpression pyExpression = expression.getLeftExpression();
        if (pyExpression instanceof PyBinaryExpression) {
            PyBinaryExpression leftBinaryOperand = (PyBinaryExpression)pyExpression;
            res.addAll(PyStringConcatenationToFormatIntention.getOperands(leftBinaryOperand));
        } else {
            res.add(expression.getLeftExpression());
        }
        pyExpression = expression.getRightExpression();
        if (pyExpression instanceof PyBinaryExpression) {
            PyBinaryExpression rightBinaryOperand = (PyBinaryExpression)pyExpression;
            res.addAll(PyStringConcatenationToFormatIntention.getOperands(rightBinaryOperand));
        } else {
            res.add(expression.getRightExpression());
        }
        ArrayList<PyExpression> arrayList = res;
        if (arrayList == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyElementType> getOperators(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(10);
        }
        ArrayList<PyElementType> res = new ArrayList<PyElementType>();
        PyExpression pyExpression = expression.getLeftExpression();
        if (pyExpression instanceof PyBinaryExpression) {
            PyBinaryExpression leftBinaryOperand = (PyBinaryExpression)pyExpression;
            res.addAll(PyStringConcatenationToFormatIntention.getOperators(leftBinaryOperand));
        }
        if ((pyExpression = expression.getRightExpression()) instanceof PyBinaryExpression) {
            PyBinaryExpression rightBinaryOperand = (PyBinaryExpression)pyExpression;
            res.addAll(PyStringConcatenationToFormatIntention.getOperators(rightBinaryOperand));
        }
        res.add(expression.getOperator());
        ArrayList<PyElementType> arrayList = res;
        if (arrayList == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static void addParamToString(@NotNull StringBuilder stringLiteral, int index, boolean useFormatMethod) {
        if (stringLiteral == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(12);
        }
        if (useFormatMethod) {
            stringLiteral.append("{").append(index).append("}");
        } else {
            stringLiteral.append("%s");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 10, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostBinaryExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperands";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperators";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostBinaryExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOperands";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOperators";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addParamToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 10, 12 -> new IllegalArgumentException(string);
        };
    }
}

