/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import oracle.net.aso.AsoException;
import oracle.net.aso.CipherBlockProcessor;
import oracle.net.aso.EncryptionEngine;
import oracle.net.aso.PaddedCipher;

class NoPadding
extends PaddedCipher {
    private final byte[] tempBuffer;

    NoPadding(int blockSize, EncryptionEngine engine, CipherBlockProcessor blockProcessor) {
        super(blockSize, engine, blockProcessor);
        this.tempBuffer = new byte[blockSize];
    }

    @Override
    public byte[] encrypt(byte[] buffer) throws AsoException {
        int length = buffer.length;
        byte[] result = new byte[length];
        if (this.coreEngine.canProcessBulk(length)) {
            this.coreEngine.encrypt(buffer, 0, length, result);
        } else {
            for (int i = 0; i < length; i += this.blockSize) {
                System.arraycopy(buffer, i, this.tempBuffer, 0, this.blockSize);
                byte[] output = this.blockProcessor.encrypt(this.tempBuffer);
                System.arraycopy(output, 0, result, i, this.blockSize);
            }
        }
        return result;
    }

    @Override
    public byte[] decrypt(byte[] ebuffer) throws AsoException {
        int elen = ebuffer.length;
        byte[] result = new byte[elen];
        if (this.coreEngine.canProcessBulk(elen)) {
            this.coreEngine.decrypt(ebuffer, 0, elen, result);
        } else {
            for (int i = 0; i < elen; i += this.blockSize) {
                System.arraycopy(ebuffer, i, this.tempBuffer, 0, this.blockSize);
                byte[] output = this.blockProcessor.decrypt(this.tempBuffer);
                System.arraycopy(output, 0, result, i, this.blockSize);
            }
        }
        return result;
    }
}

