/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayOutputStream;
import oracle.jdbc.internal.Monitor;

public class PickleOutputStream
extends ByteArrayOutputStream
implements Monitor {
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    public PickleOutputStream() {
    }

    public PickleOutputStream(int size) {
        super(size);
    }

    public int offset() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = this.count;
            return n;
        }
    }

    public void overwrite(int beginOff, byte[] b, int off, int len) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0 || beginOff + len > this.buf.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            for (int i = 0; i < len; ++i) {
                this.buf[beginOff + i] = b[off + i];
            }
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

