/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketConnection;
import org.eclipse.jetty.websocket.core.WebSocketCoreSession;
import org.eclipse.jetty.websocket.core.server.internal.AbstractHandshaker;
import org.eclipse.jetty.websocket.core.server.internal.RFC6455Negotiation;
import org.eclipse.jetty.websocket.core.server.internal.WebSocketNegotiation;
import org.eclipse.jetty.websocket.core.util.WebSocketUtils;

public final class RFC6455Handshaker
extends AbstractHandshaker {
    private static final HttpField UPGRADE_WEBSOCKET = new PreEncodedHttpField(HttpHeader.UPGRADE, "websocket");
    private static final HttpField CONNECTION_UPGRADE = new PreEncodedHttpField(HttpHeader.CONNECTION, HttpHeader.UPGRADE.asString());

    @Override
    public boolean isWebSocketUpgradeRequest(Request request) {
        if (!HttpMethod.GET.is(request.getMethod())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded method!=GET {}", (Object)request);
            }
            return false;
        }
        if (!HttpVersion.HTTP_1_1.is(request.getConnectionMetaData().getProtocol())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded version!=1.1 {}", (Object)request);
            }
            return false;
        }
        return super.isWebSocketUpgradeRequest(request);
    }

    @Override
    protected WebSocketNegotiation newNegotiation(Request request, Response response, Callback callback, WebSocketComponents webSocketComponents) {
        return new RFC6455Negotiation(request, response, callback, webSocketComponents);
    }

    @Override
    protected boolean validateNegotiation(WebSocketNegotiation negotiation) {
        boolean result = super.validateNegotiation(negotiation);
        if (!result) {
            return false;
        }
        if (((RFC6455Negotiation)negotiation).getKey() == null) {
            throw new BadMessageException("Missing request header 'Sec-WebSocket-Key'");
        }
        return true;
    }

    @Override
    protected WebSocketConnection createWebSocketConnection(Request baseRequest, WebSocketCoreSession coreSession) {
        ConnectionMetaData connectionMetaData = baseRequest.getConnectionMetaData();
        Connector connector = connectionMetaData.getConnector();
        ByteBufferPool byteBufferPool = connector.getByteBufferPool();
        WebSocketConnection connection = this.newWebSocketConnection(connectionMetaData.getConnection().getEndPoint(), connector.getExecutor(), connector.getScheduler(), byteBufferPool, coreSession);
        coreSession.setWebSocketConnection(connection);
        return connection;
    }

    @Override
    protected void prepareResponse(Response response, WebSocketNegotiation negotiation) {
        response.setStatus(101);
        HttpFields.Mutable responseFields = response.getHeaders();
        responseFields.put(UPGRADE_WEBSOCKET);
        responseFields.put(CONNECTION_UPGRADE);
        responseFields.put(HttpHeader.SEC_WEBSOCKET_ACCEPT, WebSocketUtils.hashKey((String)((RFC6455Negotiation)negotiation).getKey()));
    }
}

