import { QueuePool } from "../util/QueuePool";
import { IrcServer } from "../irc/IrcServer";
import { AgeCounters } from "matrix-appservice-bridge";
import { BridgedClient } from "./BridgedClient";
import { IrcBridge } from "../bridge/IrcBridge";
import { DataStore } from "../datastore/DataStore";
import { Gauge } from "prom-client";
import { IrcPoolClient } from "../pool-service/IrcPoolClient";
interface ReconnectionItem {
    cli: BridgedClient;
    chanList: string[];
}
export declare class ClientPool {
    private readonly ircBridge;
    private readonly store;
    private readonly redisPool?;
    private botClients;
    private virtualClients;
    private reconnectQueues;
    private identGenerator;
    private ipv6Generator;
    private ircEventBroker;
    constructor(ircBridge: IrcBridge, store: DataStore, redisPool?: IrcPoolClient | undefined);
    nickIsVirtual(server: IrcServer, nick: string): boolean;
    killAllClients(reason?: string): Promise<unknown>;
    getOrCreateReconnectQueue(server: IrcServer): QueuePool<ReconnectionItem> | null;
    setBot(server: IrcServer, client: BridgedClient): void;
    getBot(server: IrcServer): BridgedClient | undefined;
    /**
     * Discover any clients connected from a previous session when
     * using the pool
     */
    discoverPoolConnectedClients(): Promise<void>;
    loginToServer(server: IrcServer): Promise<BridgedClient>;
    /**
     * Get a {@link BridgedClient} instance. This will either return a cached instance
     * for the user, or create a new one.
     * @param server The IRC server for the IRC client.
     * @param userId The user_id associated with the connection.
     * @param displayName Displayname to set on the client.
     */
    getBridgedClient(server: IrcServer, userId: string, displayName?: string): Promise<BridgedClient>;
    private createBridgedClient;
    private createIrcClient;
    getBridgedClientByUserId(server: IrcServer, userId: string): BridgedClient | undefined;
    getBridgedClientByNick(server: IrcServer, nick: string, allowDead?: boolean): BridgedClient | undefined;
    getBridgedClientsForUserId(userId: string): BridgedClient[];
    getBridgedClientsForRegex(userIdRegexString: string): {
        [userId: string]: BridgedClient[];
    };
    private checkClientLimit;
    countTotalConnections(): number;
    totalReconnectsWaiting(serverDomain: string): number;
    updateActiveConnectionMetrics(serverDomain: string, ageCounter: AgeCounters): void;
    getNickUserIdMappingForChannel(server: IrcServer, channel: string): Map<string, string>;
    getConnectedMatrixUsersForServer(server: IrcServer): (string | null)[];
    collectConnectionStatesForAllServers(allClients: Gauge<string>, clientsByHomeserver: Gauge<string>, clientsByHomeserverMax: number): void;
    /**
     * Kill any clients for users matching a ban rule on a Matrix ban list.
     */
    checkForBannedConnectedUsers(): Promise<void>;
    private getNumberOfConnections;
    private removeBridgedClient;
    private onClientConnected;
    private onClientDisconnected;
    private reconnectClient;
    private onNickChange;
    private onJoinError;
    private onNames;
}
export {};
