/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function;

import java.util.List;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class GaussDBMinMaxFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public GaussDBMinMaxFunction(String name) {
        super(name, FunctionKind.AGGREGATE, (ArgumentsValidator)new ArgumentTypesValidator(StandardArgumentsValidators.exactly((int)1), new FunctionParameterType[]{FunctionParameterType.COMPARABLE}), StandardFunctionReturnTypeResolvers.useFirstNonNull(), StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, returnType, walker);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        String castTarget;
        boolean caseWrapper = filter != null && !GaussDBMinMaxFunction.filterClauseSupported(translator);
        sqlAppender.appendSql(this.getName());
        sqlAppender.appendSql('(');
        Expression arg = (Expression)sqlAstArguments.get(0);
        if (caseWrapper) {
            translator.getCurrentClauseStack().push((Object)Clause.WHERE);
            sqlAppender.appendSql("case when ");
            filter.accept(translator);
            translator.getCurrentClauseStack().pop();
            sqlAppender.appendSql(" then ");
            castTarget = this.renderArgument(sqlAppender, translator, arg);
            sqlAppender.appendSql(" else null end)");
        } else {
            castTarget = this.renderArgument(sqlAppender, translator, arg);
            sqlAppender.appendSql(')');
            if (filter != null) {
                translator.getCurrentClauseStack().push((Object)Clause.WHERE);
                sqlAppender.appendSql(" filter (where ");
                filter.accept(translator);
                sqlAppender.appendSql(')');
                translator.getCurrentClauseStack().pop();
            }
        }
        if (castTarget != null) {
            sqlAppender.appendSql("::");
            sqlAppender.appendSql(castTarget);
        }
    }

    private String renderArgument(SqlAppender sqlAppender, SqlAstTranslator<?> translator, Expression arg) {
        JdbcMapping sourceMapping = arg.getExpressionType().getSingleJdbcMapping();
        if (sourceMapping.getJdbcType().getDefaultSqlTypeCode() == 3000) {
            sqlAppender.appendSql("cast(");
            arg.accept(translator);
            sqlAppender.appendSql(" as text)");
            return "uuid";
        }
        arg.accept(translator);
        return null;
    }

    public String getArgumentListSignature() {
        return "(COMPARABLE arg)";
    }
}

