/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.models.xml.internal.PersistenceUnitMetadataImpl;
import org.hibernate.boot.models.xml.internal.XmlDocumentImpl;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.models.xml.spi.XmlDocument;
import org.hibernate.boot.models.xml.spi.XmlPreProcessingResult;
import org.hibernate.internal.util.StringHelper;

public class XmlPreProcessingResultImpl
implements XmlPreProcessingResult {
    private final PersistenceUnitMetadataImpl persistenceUnitMetadata;
    private final List<XmlDocument> documents = new ArrayList<XmlDocument>();
    private final List<String> managedClasses = new ArrayList<String>();
    private final List<String> managedNames = new ArrayList<String>();

    public XmlPreProcessingResultImpl(PersistenceUnitMetadataImpl persistenceUnitMetadata) {
        this.persistenceUnitMetadata = persistenceUnitMetadata;
    }

    public XmlPreProcessingResultImpl(PersistenceUnitMetadata persistenceUnitMetadata) {
        this((PersistenceUnitMetadataImpl)persistenceUnitMetadata);
    }

    public XmlPreProcessingResultImpl() {
        this(new PersistenceUnitMetadataImpl());
    }

    public PersistenceUnitMetadataImpl getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    @Override
    public List<XmlDocument> getDocuments() {
        return this.documents;
    }

    @Override
    public List<String> getMappedClasses() {
        return this.managedClasses;
    }

    @Override
    public List<String> getMappedNames() {
        return this.managedNames;
    }

    public void addDocument(Binding<JaxbEntityMappingsImpl> binding) {
        XmlDocumentImpl xmlDocument = XmlDocumentImpl.consume(binding, this.persistenceUnitMetadata);
        this.documents.add(xmlDocument);
        JaxbEntityMappingsImpl jaxbRoot = binding.getRoot();
        this.persistenceUnitMetadata.apply(jaxbRoot.getPersistenceUnitMetadata());
        jaxbRoot.getEmbeddables().forEach(jaxbEmbeddable -> {
            if (StringHelper.isNotEmpty(jaxbEmbeddable.getClazz())) {
                this.managedClasses.add(XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEmbeddable));
            } else if (StringHelper.isNotEmpty(jaxbEmbeddable.getName())) {
                this.managedNames.add(jaxbEmbeddable.getName());
            }
        });
        jaxbRoot.getMappedSuperclasses().forEach(jaxbMappedSuperclass -> this.managedClasses.add(XmlProcessingHelper.determineClassName(jaxbRoot, jaxbMappedSuperclass)));
        jaxbRoot.getEntities().forEach(jaxbEntity -> {
            if (StringHelper.isNotEmpty(jaxbEntity.getClazz())) {
                this.managedClasses.add(XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEntity));
            } else if (StringHelper.isNotEmpty(jaxbEntity.getName())) {
                this.managedNames.add(jaxbEntity.getName());
            }
        });
    }
}

