/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.ModelsContext;

public class FilterDefAnnotation
implements FilterDef {
    private String name;
    private String defaultCondition;
    private boolean autoEnabled;
    private boolean applyToLoadByKey;
    private ParamDef[] parameters;

    public FilterDefAnnotation(ModelsContext modelContext) {
        this.defaultCondition = "";
        this.parameters = new ParamDef[0];
        this.autoEnabled = false;
    }

    public FilterDefAnnotation(FilterDef annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.defaultCondition = annotation.defaultCondition();
        this.autoEnabled = annotation.autoEnabled();
        this.applyToLoadByKey = annotation.applyToLoadByKey();
        this.parameters = (ParamDef[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.FILTER_DEF, "parameters", modelContext);
    }

    public FilterDefAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.defaultCondition = (String)attributeValues.get("defaultCondition");
        this.autoEnabled = (Boolean)attributeValues.get("autoEnabled");
        this.applyToLoadByKey = (Boolean)attributeValues.get("applyToLoadByKey");
        this.parameters = (ParamDef[])attributeValues.get("parameters");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return FilterDef.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String defaultCondition() {
        return this.defaultCondition;
    }

    public void defaultCondition(String value) {
        this.defaultCondition = value;
    }

    @Override
    public boolean autoEnabled() {
        return this.autoEnabled;
    }

    public void autoEnabled(boolean value) {
        this.autoEnabled = value;
    }

    @Override
    public boolean applyToLoadByKey() {
        return this.applyToLoadByKey;
    }

    public void applyToLoadByKey(boolean value) {
        this.applyToLoadByKey = value;
    }

    @Override
    public ParamDef[] parameters() {
        return this.parameters;
    }

    public void parameters(ParamDef[] value) {
        this.parameters = value;
    }
}

