/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.keycloak.compatibility.CompatibilityMetadataProvider;
import org.keycloak.compatibility.CompatibilityResult;
import org.keycloak.compatibility.Util;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractUpdatesCommand;
import org.keycloak.util.JsonSerialization;
import picocli.CommandLine;

@CommandLine.Command(name="check", description={"Checks if the metadata is compatible with the current configuration. A zero exit code means a rolling update is possible between old and the current metadata."})
public class UpdateCompatibilityCheck
extends AbstractUpdatesCommand {
    public static final String NAME = "check";
    public static final String INPUT_OPTION_NAME = "--file";
    public static final TypeReference<Map<String, Map<String, String>>> METADATA_TYPE_REF = new TypeReference<Map<String, Map<String, String>>>(){};
    @CommandLine.Option(names={"--file"}, paramLabel="FILE", description={"The file path to read the metadata."})
    String inputFile;

    @Override
    int executeAction() {
        Map<String, Map<String, String>> info = this.readServerInfo();
        Map<String, CompatibilityMetadataProvider> providers = UpdateCompatibilityCheck.loadAllProviders();
        Iterator idIterator = Util.mergeKeySet(info, providers).sorted().iterator();
        while (idIterator.hasNext()) {
            String id = (String)idIterator.next();
            CompatibilityMetadataProvider provider = providers.get(id);
            if (provider == null) {
                this.picocli.error("[%s] Provider not found. Rolling Update is not available.".formatted(id));
                return CompatibilityResult.ExitCode.RECREATE.value();
            }
            CompatibilityResult result = provider.isCompatible(Map.copyOf(info.getOrDefault(id, Map.of())));
            result.endMessage().ifPresent(this.picocli.getOutWriter()::println);
            if (!Util.isNotCompatible((CompatibilityResult)result)) continue;
            result.errorMessage().ifPresent(this.picocli::error);
            return result.exitCode();
        }
        this.picocli.getOutWriter().println("[OK] Rolling Update is available.");
        return CompatibilityResult.ExitCode.ROLLING.value();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean includeRuntime() {
        return true;
    }

    @Override
    protected void validateConfig() {
        super.validateConfig();
        this.validateFileParameter();
    }

    private void validateFileParameter() {
        if (this.inputFile == null || this.inputFile.isBlank()) {
            throw new PropertyException("Missing required argument: --file");
        }
        File file = new File(this.inputFile);
        if (!file.exists()) {
            throw new PropertyException("Incorrect argument %s. Path '%s' not found".formatted(INPUT_OPTION_NAME, file.getAbsolutePath()));
        }
        UpdateCompatibilityCheck.validateFileIsNotDirectory(file, INPUT_OPTION_NAME);
    }

    private Map<String, Map<String, String>> readServerInfo() {
        File file = new File(this.inputFile);
        try {
            return (Map)JsonSerialization.mapper.readValue(file, METADATA_TYPE_REF);
        }
        catch (IOException e) {
            throw new PropertyException("Unable to read file '%s'".formatted(file.getAbsolutePath()), e);
        }
    }
}

