/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.ClientWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.SSLOptions;

@VertxGen
public interface WebSocketClient
extends Measured {
    public ClientWebSocket webSocket();

    default public void connect(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.connect(new WebSocketConnectOptions().setPort(port).setHost(host).setURI(requestURI), handler);
    }

    default public Future<WebSocket> connect(int port, String host, String requestURI) {
        return this.connect(new WebSocketConnectOptions().setPort(port).setHost(host).setURI(requestURI));
    }

    default public void connect(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.connect(new WebSocketConnectOptions().setURI(requestURI).setHost(host), handler);
    }

    default public Future<WebSocket> connect(String host, String requestURI) {
        return this.connect(new WebSocketConnectOptions().setURI(requestURI).setHost(host));
    }

    default public void connect(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.connect(new WebSocketConnectOptions().setURI(requestURI), handler);
    }

    default public Future<WebSocket> connect(String requestURI) {
        return this.connect(new WebSocketConnectOptions().setURI(requestURI));
    }

    public void connect(WebSocketConnectOptions var1, Handler<AsyncResult<WebSocket>> var2);

    public Future<WebSocket> connect(WebSocketConnectOptions var1);

    default public Future<Boolean> updateSSLOptions(SSLOptions options) {
        return this.updateSSLOptions(options, false);
    }

    default public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
        Future<Boolean> fut = this.updateSSLOptions(options);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<Boolean> updateSSLOptions(SSLOptions var1, boolean var2);

    default public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
        Future<Boolean> fut = this.updateSSLOptions(options, force);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public void close(Handler<AsyncResult<Void>> var1);

    public Future<Void> close();
}

