/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Map;
import java.util.Optional;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.GraphSemantic;

public interface NaturalIdLoadAccess<T> {
    default public NaturalIdLoadAccess<T> with(LockMode lockMode) {
        return this.with(lockMode, PessimisticLockScope.NORMAL);
    }

    public NaturalIdLoadAccess<T> with(LockMode var1, PessimisticLockScope var2);

    public NaturalIdLoadAccess<T> with(Timeout var1);

    @Deprecated(since="7.0", forRemoval=true)
    public NaturalIdLoadAccess<T> with(LockOptions var1);

    default public NaturalIdLoadAccess<T> withFetchGraph(EntityGraph<T> graph) {
        return this.with(graph, GraphSemantic.FETCH);
    }

    default public NaturalIdLoadAccess<T> withLoadGraph(EntityGraph<T> graph) {
        return this.with(graph, GraphSemantic.LOAD);
    }

    public NaturalIdLoadAccess<T> with(EntityGraph<T> var1, GraphSemantic var2);

    public NaturalIdLoadAccess<T> enableFetchProfile(String var1);

    public NaturalIdLoadAccess<T> disableFetchProfile(String var1);

    public <X> NaturalIdLoadAccess<T> using(SingularAttribute<? super T, X> var1, X var2);

    public NaturalIdLoadAccess<T> using(String var1, Object var2);

    public NaturalIdLoadAccess<T> using(Map<String, ?> var1);

    public NaturalIdLoadAccess<T> setSynchronizationEnabled(boolean var1);

    public T getReference();

    public T load();

    public Optional<T> loadOptional();
}

