/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;

public class ConsumerProtocolUtils {
    public static void writeTaskIdTo(TaskId taskId, DataOutputStream out, int version) throws IOException {
        out.writeInt(taskId.subtopology());
        out.writeInt(taskId.partition());
        if (version >= 10) {
            if (taskId.topologyName() != null) {
                out.writeInt(taskId.topologyName().length());
                out.writeChars(taskId.topologyName());
            } else {
                out.writeInt(0);
            }
        } else if (taskId.topologyName() != null) {
            throw new TaskAssignmentException("Named topologies are not compatible with protocol version " + version);
        }
    }

    public static TaskId readTaskIdFrom(DataInputStream in, int version) throws IOException {
        String namedTopology;
        int subtopology = in.readInt();
        int partition = in.readInt();
        if (version >= 10) {
            int numNamedTopologyChars = in.readInt();
            StringBuilder namedTopologyBuilder = new StringBuilder();
            for (int i = 0; i < numNamedTopologyChars; ++i) {
                namedTopologyBuilder.append(in.readChar());
            }
            namedTopology = namedTopologyBuilder.toString();
        } else {
            namedTopology = null;
        }
        return new TaskId(subtopology, partition, ConsumerProtocolUtils.getNamedTopologyOrElseNull(namedTopology));
    }

    public static void writeTaskIdTo(TaskId taskId, ByteBuffer buf, int version) {
        buf.putInt(taskId.subtopology());
        buf.putInt(taskId.partition());
        if (version >= 10) {
            if (taskId.topologyName() != null) {
                buf.putInt(taskId.topologyName().length());
                for (char c : taskId.topologyName().toCharArray()) {
                    buf.putChar(c);
                }
            } else {
                buf.putInt(0);
            }
        } else if (taskId.topologyName() != null) {
            throw new TaskAssignmentException("Named topologies are not compatible with protocol version " + version);
        }
    }

    public static TaskId readTaskIdFrom(ByteBuffer buf, int version) {
        String namedTopology;
        int subtopology = buf.getInt();
        int partition = buf.getInt();
        if (version >= 10) {
            int numNamedTopologyChars = buf.getInt();
            StringBuilder namedTopologyBuilder = new StringBuilder();
            for (int i = 0; i < numNamedTopologyChars; ++i) {
                namedTopologyBuilder.append(buf.getChar());
            }
            namedTopology = namedTopologyBuilder.toString();
        } else {
            namedTopology = null;
        }
        return new TaskId(subtopology, partition, ConsumerProtocolUtils.getNamedTopologyOrElseNull(namedTopology));
    }

    private static String getNamedTopologyOrElseNull(String namedTopology) {
        return namedTopology == null || namedTopology.length() == 0 ? null : namedTopology;
    }
}

