/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterReplicaLogDirsResponse
extends AbstractResponse {
    private final AlterReplicaLogDirsResponseData data;

    public AlterReplicaLogDirsResponse(AlterReplicaLogDirsResponseData data) {
        super(ApiKeys.ALTER_REPLICA_LOG_DIRS);
        this.data = data;
    }

    @Override
    public AlterReplicaLogDirsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.results().forEach(topicResult -> topicResult.partitions().forEach(partitionResult -> AlterReplicaLogDirsResponse.updateErrorCounts(errorCounts, Errors.forCode(partitionResult.errorCode()))));
        return errorCounts;
    }

    public static AlterReplicaLogDirsResponse parse(Readable readable, short version) {
        return new AlterReplicaLogDirsResponse(new AlterReplicaLogDirsResponseData(readable, version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

