/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.stream.Collectors;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.server.share.persister.GroupTopicPartitionData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PartitionStateBatchData;
import org.apache.kafka.server.share.persister.PersisterParameters;
import org.apache.kafka.server.share.persister.PersisterStateBatch;
import org.apache.kafka.server.share.persister.TopicData;

public class WriteShareGroupStateParameters
implements PersisterParameters {
    private final GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData;

    private WriteShareGroupStateParameters(GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData) {
        this.groupTopicPartitionData = groupTopicPartitionData;
    }

    public GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData() {
        return this.groupTopicPartitionData;
    }

    public static WriteShareGroupStateParameters from(WriteShareGroupStateRequestData data) {
        return new Builder().setGroupTopicPartitionData(new GroupTopicPartitionData<PartitionStateBatchData>(data.groupId(), data.topics().stream().map(writeStateData -> new TopicData(writeStateData.topicId(), writeStateData.partitions().stream().map(partitionData -> PartitionFactory.newPartitionStateBatchData(partitionData.partition(), partitionData.stateEpoch(), partitionData.startOffset(), partitionData.leaderEpoch(), partitionData.stateBatches().stream().map(PersisterStateBatch::from).collect(Collectors.toList()))).collect(Collectors.toList()))).collect(Collectors.toList()))).build();
    }

    public String toString() {
        return "WriteShareGroupStateParameters(" + String.valueOf(this.groupTopicPartitionData) + ")";
    }

    public static class Builder {
        private GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData;

        public Builder setGroupTopicPartitionData(GroupTopicPartitionData<PartitionStateBatchData> groupTopicPartitionData) {
            this.groupTopicPartitionData = groupTopicPartitionData;
            return this;
        }

        public WriteShareGroupStateParameters build() {
            return new WriteShareGroupStateParameters(this.groupTopicPartitionData);
        }
    }
}

