/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Decrease the image size by cropping the image to the selected region
bounds.


ExtractImageFilter changes the image boundary of an image by removing pixels outside the
target region. The region is specified as a Size and Index. The Size must be specified, while the Index defaults to zeros.

ExtractImageFilter can collapses dimensions so that the input image may have more
dimensions than the output image (i.e. 4-D input image to a 3-D output
image). To specify what dimensions to collapse, the Size must be specified. For any dimension dim where the Size[dim] == 0, that dimension is collapsed. The index to collapse on is
specified by Index[dim]. For example, we have a image 4D = a 4x4x4x4 image, and we want
to get a 3D image, 3D = a 4x4x4 image, specified as [x,y,z,2] from 4D
(i.e. the 3rd "time" slice from 4D). The Size = [4,4,4,0] and Index = [0,0,0,2].

The number of dimension in Size and Index must at least dimension of the input image. The number of non-zero
dimensions in Size determines the output dimension.

Determining the direction of the collapsed output image from an larger
dimensional input space is an ill defined problem in general. It is
required that the application developer select the desired
transformation strategy for collapsing direction cosines. The strategy
defaults to the guess approach. Direction Collapsing Strategies: 1)
DirectionCollapseToUnknown(); This is the default in ITK and the
filter can not run when this is set. 1) DirectionCollapseToIdentity();
Output has identity direction no matter what 2)
DirectionCollapseToSubmatrix(); Output direction is the sub-matrix if
it is positive definite, else throw an exception.

This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.


See:
 CropImageFilter

 itk::simple::Extract for the procedural interface

 itk::ExtractImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkExtractImageFilter.h
*/
public class ExtractImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ExtractImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ExtractImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ExtractImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ExtractImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ExtractImageFilter::~ExtractImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ExtractImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ExtractImageFilter::ExtractImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ExtractImageFilter() {
    this(SimpleITKJNI.new_ExtractImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ExtractImageFilter::SetSize(std::vector&lt; unsigned int &gt; Size)

Set the size of the region to extract.


The size of the region to extract should be specified. Dimensions
which have a size of 0 are collapsed. The number of non-zero sized
determines the output dimension.

*/
public  void setSize(VectorUInt32 Size) {
    SimpleITKJNI.ExtractImageFilter_setSize(swigCPtr, this, VectorUInt32.getCPtr(Size), Size);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ExtractImageFilter::GetSize() const

Get the size of the region to extract.

*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.ExtractImageFilter_getSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ExtractImageFilter::SetIndex(std::vector&lt; int &gt; Index)

Set the starting index of the input image to extract.


The index defaults to all zeros.

*/
public  void setIndex(VectorInt32 Index) {
    SimpleITKJNI.ExtractImageFilter_setIndex(swigCPtr, this, VectorInt32.getCPtr(Index), Index);
  }

  /**
std::vector&lt;int&gt; itk::simple::ExtractImageFilter::GetIndex() const

Get the starting index to extract.

*/
public  VectorInt32 getIndex() {
    return new VectorInt32(SimpleITKJNI.ExtractImageFilter_getIndex(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ExtractImageFilter::SetDirectionCollapseToStrategy(DirectionCollapseToStrategyType DirectionCollapseToStrategy)

Set the strategy to be used to collapse physical space dimensions.


DIRECTIONCOLLAPSETOIDENTITY Set the strategy so that all collapsed
images have an identity direction. Use this strategy when you know
that retention of the physical space orientation of the collapsed
image is not important.

DIRECTIONCOLLAPSETOGUESS Set the strategy so that all collapsed images
where output direction is the sub-matrix if it is positive definite,
else return identity. This is backwards compatible with ITKv3, but is
highly discouraged because the results are difficult to anticipate
under differing data scenarios.

DIRECTIONCOLLAPSETOSUBMATRIX Set the strategy so that all collapsed
images where output direction is the sub-matrix if it is positive
definite, else throw an exception. Use this strategy when it is known
that properly identified physical space sub-volumes can be reliably
extracted from a higher dimensional space. For example when the
application programmer knows that a 4D image is 3D+time, and that the
3D sub-space is properly defined.

*/
public  void setDirectionCollapseToStrategy(ExtractImageFilter.DirectionCollapseToStrategyType DirectionCollapseToStrategy) {
    SimpleITKJNI.ExtractImageFilter_setDirectionCollapseToStrategy(swigCPtr, this, DirectionCollapseToStrategy.swigValue());
  }

  /**
DirectionCollapseToStrategyType itk::simple::ExtractImageFilter::GetDirectionCollapseToStrategy() const

Get the currently set strategy for collapsing directions of physical
space.

*/
public  ExtractImageFilter.DirectionCollapseToStrategyType getDirectionCollapseToStrategy() {
    return ExtractImageFilter.DirectionCollapseToStrategyType.swigToEnum(SimpleITKJNI.ExtractImageFilter_getDirectionCollapseToStrategy(swigCPtr, this));
  }

  /**
std::string itk::simple::ExtractImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ExtractImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ExtractImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ExtractImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ExtractImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ExtractImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  public final static class DirectionCollapseToStrategyType {
    public final static ExtractImageFilter.DirectionCollapseToStrategyType DIRECTIONCOLLAPSETOUNKOWN = new ExtractImageFilter.DirectionCollapseToStrategyType("DIRECTIONCOLLAPSETOUNKOWN");
    public final static ExtractImageFilter.DirectionCollapseToStrategyType DIRECTIONCOLLAPSETOIDENTITY = new ExtractImageFilter.DirectionCollapseToStrategyType("DIRECTIONCOLLAPSETOIDENTITY");
    public final static ExtractImageFilter.DirectionCollapseToStrategyType DIRECTIONCOLLAPSETOSUBMATRIX = new ExtractImageFilter.DirectionCollapseToStrategyType("DIRECTIONCOLLAPSETOSUBMATRIX");
    public final static ExtractImageFilter.DirectionCollapseToStrategyType DIRECTIONCOLLAPSETOGUESS = new ExtractImageFilter.DirectionCollapseToStrategyType("DIRECTIONCOLLAPSETOGUESS");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static DirectionCollapseToStrategyType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + DirectionCollapseToStrategyType.class + " with value " + swigValue);
    }

    private DirectionCollapseToStrategyType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private DirectionCollapseToStrategyType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private DirectionCollapseToStrategyType(String swigName, DirectionCollapseToStrategyType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static DirectionCollapseToStrategyType[] swigValues = { DIRECTIONCOLLAPSETOUNKOWN, DIRECTIONCOLLAPSETOIDENTITY, DIRECTIONCOLLAPSETOSUBMATRIX, DIRECTIONCOLLAPSETOGUESS };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
