/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.UnsatisfiedRequirement;
import org.assertj.core.util.Strings;

public class ElementsShouldSatisfy
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory elementsShouldSatisfyAny(Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements, AssertionInfo info) {
        return new ElementsShouldSatisfy("%nExpecting any element of:%n  %s%nto satisfy the given assertions requirements but none did:%n%n", actual, elementsNotSatisfyingRequirements, info);
    }

    public static ErrorMessageFactory elementsShouldSatisfy(Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRestrictions, AssertionInfo info) {
        return new ElementsShouldSatisfy("%nExpecting all elements of:%n  %s%nto satisfy given requirements, but these elements did not:%n%n", actual, elementsNotSatisfyingRestrictions, info);
    }

    public static ErrorMessageFactory elementsShouldSatisfyExactly(Object actual, Map<Integer, UnsatisfiedRequirement> unsatisfiedRequirements, AssertionInfo info) {
        return new ElementsShouldSatisfy("%nExpecting each element of:%n  %s%nto satisfy the requirements at its index, but these elements did not:%n%n", actual, unsatisfiedRequirements, info);
    }

    private ElementsShouldSatisfy(String message, Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements, AssertionInfo info) {
        super(message + ElementsShouldSatisfy.describeErrors(elementsNotSatisfyingRequirements, info), actual);
    }

    private ElementsShouldSatisfy(String message, Object actual, Map<Integer, UnsatisfiedRequirement> unsatisfiedRequirements, AssertionInfo info) {
        super(message + ElementsShouldSatisfy.describeErrors(unsatisfiedRequirements, info), actual);
    }

    private static String describeErrors(Map<Integer, UnsatisfiedRequirement> unsatisfiedRequirements, AssertionInfo info) {
        return Strings.escapePercent(unsatisfiedRequirements.entrySet().stream().map(requirementAtIndex -> ElementsShouldSatisfy.describe(requirementAtIndex, info)).collect(Collectors.joining(String.format("%n%n", new Object[0]))));
    }

    private static String describe(Map.Entry<Integer, UnsatisfiedRequirement> requirementsAtIndex, AssertionInfo info) {
        int index = requirementsAtIndex.getKey();
        UnsatisfiedRequirement unsatisfiedRequirement = requirementsAtIndex.getValue();
        return unsatisfiedRequirement.describe(index, info);
    }

    private static String describeErrors(List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements, AssertionInfo info) {
        return Strings.escapePercent(elementsNotSatisfyingRequirements.stream().map(unsatisfiedRequirement -> unsatisfiedRequirement.describe(info)).collect(Collectors.joining(String.format("%n%n", new Object[0]))));
    }

    public static UnsatisfiedRequirement unsatisfiedRequirement(Object elementNotSatisfyingRequirements, String errorMessage) {
        return new UnsatisfiedRequirement(elementNotSatisfyingRequirements, errorMessage);
    }
}

