/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaSimpleVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u000b\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"doesDoubleColonUseLHS", "", "lhs", "Lcom/intellij/psi/PsiElement;", "doesCallExpressionUseCallee", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "callee", "doesPropertyAccessorUseBody", "propertyAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "body", "doesNamedFunctionUseBody", "namedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isSimpleVariableAccessCall", "reference", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "returnsUnit", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "analysis-api-fir"})
public final class KaFirExpressionInformationProviderKt {
    private static final boolean doesDoubleColonUseLHS(PsiElement lhs) {
        KtReference ktReference;
        PsiElement inner = PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations((PsiElement)lhs);
        if (inner instanceof KtReferenceExpression) {
            ktReference = ReferenceUtilsKt.getMainReference((KtReferenceExpression)((KtReferenceExpression)inner));
        } else if (inner instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression = ((KtDotQualifiedExpression)inner).getSelectorExpression();
            ktReference = ktExpression instanceof KtReferenceExpression ? (KtReferenceExpression)ktExpression : null;
            if (ktReference == null || (ktReference = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReference)) == null) {
                return true;
            }
        } else {
            return true;
        }
        KtReference reference = ktReference;
        PsiElement resolution = reference.resolve();
        return resolution != null && !(resolution instanceof KtClass);
    }

    private static final boolean doesCallExpressionUseCallee(KaSession $this$doesCallExpressionUseCallee, PsiElement callee) {
        return !(callee instanceof KtReferenceExpression) || KaFirExpressionInformationProviderKt.isSimpleVariableAccessCall($this$doesCallExpressionUseCallee, (KtReferenceExpression)callee);
    }

    private static final boolean doesPropertyAccessorUseBody(KtPropertyAccessor propertyAccessor, PsiElement body2) {
        return propertyAccessor.isSetter() || propertyAccessor.isGetter() && !(body2 instanceof KtBlockExpression);
    }

    private static final boolean doesNamedFunctionUseBody(KaSession $this$doesNamedFunctionUseBody, KtNamedFunction namedFunction, PsiElement body2) {
        boolean bl;
        if (Intrinsics.areEqual((Object)namedFunction.getBodyBlockExpression(), (Object)body2)) {
            bl = false;
        } else if (!KaFirExpressionInformationProviderKt.returnsUnit($this$doesNamedFunctionUseBody, (KtDeclaration)namedFunction)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)namedFunction.getBodyExpression(), (Object)body2)) {
            Intrinsics.checkNotNull((Object)body2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            KaType kaType = $this$doesNamedFunctionUseBody.getExpressionType((KtExpression)body2);
            bl = kaType != null ? $this$doesNamedFunctionUseBody.isUnitType(kaType) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isSimpleVariableAccessCall(KaSession $this$isSimpleVariableAccessCall, KtReferenceExpression reference) {
        KaCallInfo resolution = $this$isSimpleVariableAccessCall.resolveToCall((KtElement)reference);
        return resolution instanceof KaSuccessCallInfo ? ((KaSuccessCallInfo)resolution).getCall() instanceof KaSimpleVariableAccessCall : false;
    }

    private static final boolean returnsUnit(KaSession $this$returnsUnit, KtDeclaration declaration) {
        return $this$returnsUnit.isUnitType($this$returnsUnit.getReturnType(declaration));
    }

    public static final /* synthetic */ boolean access$doesPropertyAccessorUseBody(KtPropertyAccessor propertyAccessor, PsiElement body2) {
        return KaFirExpressionInformationProviderKt.doesPropertyAccessorUseBody(propertyAccessor, body2);
    }

    public static final /* synthetic */ boolean access$returnsUnit(KaSession $receiver, KtDeclaration declaration) {
        return KaFirExpressionInformationProviderKt.returnsUnit($receiver, declaration);
    }

    public static final /* synthetic */ boolean access$doesNamedFunctionUseBody(KaSession $receiver, KtNamedFunction namedFunction, PsiElement body2) {
        return KaFirExpressionInformationProviderKt.doesNamedFunctionUseBody($receiver, namedFunction, body2);
    }

    public static final /* synthetic */ boolean access$doesCallExpressionUseCallee(KaSession $receiver, PsiElement callee) {
        return KaFirExpressionInformationProviderKt.doesCallExpressionUseCallee($receiver, callee);
    }

    public static final /* synthetic */ boolean access$doesDoubleColonUseLHS(PsiElement lhs) {
        return KaFirExpressionInformationProviderKt.doesDoubleColonUseLHS(lhs);
    }
}

