/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.toolsets.general;

import com.intellij.lang.documentation.impl.TargetsKt;
import com.intellij.mcpserver.McpCallInfoKt;
import com.intellij.mcpserver.McpServerBundle;
import com.intellij.mcpserver.McpToolKt;
import com.intellij.mcpserver.McpToolset;
import com.intellij.mcpserver.ToolCallListenerKt;
import com.intellij.mcpserver.annotations.McpDescription;
import com.intellij.mcpserver.annotations.McpTool;
import com.intellij.mcpserver.toolsets.general.CodeInsightToolset;
import com.intellij.mcpserver.toolsets.general.CodeInsightToolset$SymbolInfoResult$;
import com.intellij.mcpserver.util.Fs_utilKt;
import com.intellij.mcpserver.util.HtmlToMarkdownConverterKt;
import com.intellij.mcpserver.util.Psi_utilKt;
import com.intellij.mcpserver.util.SymbolInfo;
import com.intellij.mcpserver.util.SymbolInfo$;
import com.intellij.model.Pointer;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.documentation.DocumentationData;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.impl.ImplKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.DocumentUtil;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.serialization.EncodeDefault;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\tH\u0087@\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/mcpserver/toolsets/general/CodeInsightToolset;", "Lcom/intellij/mcpserver/McpToolset;", "<init>", "()V", "get_symbol_info", "Lcom/intellij/mcpserver/toolsets/general/CodeInsightToolset$SymbolInfoResult;", "filePath", "", "line", "", "column", "(Ljava/lang/String;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "SymbolInfoResult", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nCodeInsightToolset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeInsightToolset.kt\ncom/intellij/mcpserver/toolsets/general/CodeInsightToolset\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n374#2:87\n374#2:88\n1563#3:89\n1634#3,3:90\n1#4:93\n*S KotlinDebug\n*F\n+ 1 CodeInsightToolset.kt\ncom/intellij/mcpserver/toolsets/general/CodeInsightToolset\n*L\n46#1:87\n47#1:88\n65#1:89\n65#1:90,3\n*E\n"})
public final class CodeInsightToolset
implements McpToolset {
    /*
     * Unable to fully structure code
     */
    @McpTool
    @McpDescription(description="\n    |Retrieves information about the symbol at the specified position in the specified file.\n    |Provides the same information as Quick Documentation feature of IntelliJ IDEA does.\n    |\n    |This tool is useful for getting information about the symbol at the specified position in the specified file.\n    |The information may include the symbol's name, signature, type, documentation, etc. It depends on a particular language.\n    |\n    |If the position has a reference to a symbol the tool will return a piece of code with the declaration of the symbol if possible.\n    |\n    |Use this tool to understand symbols declaration, semantics, where it's declared, etc.\n  ")
    @Nullable
    public final Object get_symbol_info(@McpDescription(description="Path relative to the project root") @NotNull String filePath, @McpDescription(description="1-based line number") int line, @McpDescription(description="1-based column number") int column, @NotNull Continuation<? super SymbolInfoResult> $completion) {
        if (!($completion instanceof get_symbol_info.1)) ** GOTO lbl-1000
        var14_5 = $completion;
        if ((var14_5.label & -2147483648) != 0) {
            var14_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ CodeInsightToolset this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.get_symbol_info(null, 0, 0, (Continuation<? super SymbolInfoResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$currentCoroutineContext = false;
                $i$f$currentCoroutineContext = new Object[]{filePath, Boxing.boxInt((int)line), Boxing.boxInt((int)column)};
                ToolCallListenerKt.reportToolActivity($continuation.getContext(), McpServerBundle.INSTANCE.message("tool.activity.getting.symbol.info", $i$f$currentCoroutineContext));
                $i$f$currentCoroutineContext = false;
                project = McpCallInfoKt.getProject($continuation.getContext());
                resolvedPath = Fs_utilKt.resolveInProject$default(project, filePath, false, 2, null);
                v0 = LocalFileSystem.getInstance().findFileByNioFile(resolvedPath);
                if (v0 == null && (v0 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(resolvedPath)) == null) {
                    McpToolKt.mcpFail$default("File not found: " + filePath, null, 2, null);
                    throw new KotlinNothingValueException();
                }
                virtualFile = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)filePath);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)resolvedPath);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)virtualFile);
                $continuation.I$0 = line;
                $continuation.I$1 = column;
                $continuation.label = 1;
                v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, get_symbol_info$lambda$2(com.intellij.openapi.vfs.VirtualFile java.lang.String com.intellij.openapi.project.Project int int ), ()Lkotlin/Pair;)((VirtualFile)virtualFile, (String)filePath, (Project)project, (int)line, (int)column), (Continuation)$continuation);
                if (v1 == var15_7) {
                    return var15_7;
                }
                ** GOTO lbl46
            }
            case 1: {
                column = $continuation.I$1;
                line = $continuation.I$0;
                virtualFile = (VirtualFile)$continuation.L$3;
                resolvedPath = (Path)$continuation.L$2;
                project = (Project)$continuation.L$1;
                filePath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl46:
                // 2 sources

                var8_16 = (Pair)v1;
                documentationTargets = (List)var8_16.component1();
                symbolInfo = (SymbolInfo)var8_16.component2();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)filePath);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)resolvedPath);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)virtualFile);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)documentationTargets);
                $continuation.L$5 = symbolInfo;
                $continuation.I$0 = line;
                $continuation.I$1 = column;
                $continuation.label = 2;
                v2 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends DocumentationData>>, Object>((List<? extends Pointer<? extends DocumentationTarget>>)documentationTargets, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ List<Pointer<? extends DocumentationTarget>> $documentationTargets;
                    {
                        this.$documentationTargets = $documentationTargets;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$coroutineScope;
                                void $this$mapTo$iv$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                Iterable $this$map$iv = this.$documentationTargets;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void pointer;
                                    Pointer pointer2 = (Pointer)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(ImplKt.computeDocumentationAsync((CoroutineScope)$this$coroutineScope, (Pointer)pointer));
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                                this.label = 1;
                                Object object2 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                                if (object2 != object) return CollectionsKt.filterNotNull((Iterable)((Iterable)object2));
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return CollectionsKt.filterNotNull((Iterable)((Iterable)object2));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<DocumentationData>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var15_7) {
                    return var15_7;
                }
                ** GOTO lbl73
            }
            case 2: {
                column = $continuation.I$1;
                line = $continuation.I$0;
                symbolInfo = (SymbolInfo)$continuation.L$5;
                documentationTargets = (List)$continuation.L$4;
                virtualFile = (VirtualFile)$continuation.L$3;
                resolvedPath = (Path)$continuation.L$2;
                project = (Project)$continuation.L$1;
                filePath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl73:
                // 2 sources

                results = (List)v2;
                markdowns = CollectionsKt.joinToString$default((Iterable)results, (CharSequence)"\n", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get_symbol_info$lambda$3(com.intellij.platform.backend.documentation.DocumentationData ), (Lcom/intellij/platform/backend/documentation/DocumentationData;)Ljava/lang/CharSequence;)(), (int)30, null);
                return new SymbolInfoResult(symbolInfo, markdowns);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair get_symbol_info$lambda$2(VirtualFile $virtualFile, String $filePath, Project $project, int $line, int $column) {
        SymbolInfo symbolInfo;
        Collection collection;
        void $this$mapTo$iv$iv;
        PsiReference psiReference;
        Document document = FileDocumentManager.getInstance().getDocument($virtualFile);
        if (document == null) {
            McpToolKt.mcpFail$default("Cannot read file: " + $filePath, null, 2, null);
            throw new KotlinNothingValueException();
        }
        Document document2 = document;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)$project).getPsiFile(document2);
        if (psiFile == null) {
            McpToolKt.mcpFail$default("Cannot get symbol information for file '" + $filePath + "'", null, 2, null);
            throw new KotlinNothingValueException();
        }
        PsiFile psiFile2 = psiFile;
        if (!DocumentUtil.isValidLine((int)($line - 1), (Document)document2)) {
            McpToolKt.mcpFail$default("Line number is out of bounds of the document", null, 2, null);
            throw new KotlinNothingValueException();
        }
        int lineStartOffset = document2.getLineStartOffset($line - 1);
        int offset = lineStartOffset + $column - 1;
        if (!DocumentUtil.isValidOffset((int)offset, (Document)document2)) {
            McpToolKt.mcpFail$default("Line and column " + $line + ":" + $column + "(offset=" + offset + ") is out of bounds (file has " + document2.getTextLength() + " characters)", null, 2, null);
            throw new KotlinNothingValueException();
        }
        PsiReference psiReference2 = psiReference = psiFile2.findReferenceAt(offset);
        PsiElement resolvedReference = psiReference2 != null ? psiReference2.resolve() : null;
        Iterable $this$map$iv = TargetsKt.documentationTargets((PsiFile)psiFile2, (int)offset);
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentationTarget documentationTarget = (DocumentationTarget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createPointer());
        }
        Collection collection2 = (List)destination$iv$iv;
        PsiElement psiElement = resolvedReference;
        if (psiElement != null) {
            void it;
            PsiElement $i$f$map2 = psiElement;
            collection = collection2;
            boolean bl = false;
            symbolInfo = Psi_utilKt.getElementSymbolInfo((PsiElement)it, 1);
            collection2 = collection;
        } else {
            symbolInfo = null;
        }
        return TuplesKt.to((Object)collection2, symbolInfo);
    }

    private static final CharSequence get_symbol_info$lambda$3(DocumentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HtmlToMarkdownConverterKt.convertHtmlToMarkdown(it.getHtml());
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 $2\u00020\u0001:\u0002#$B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B/\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/intellij/mcpserver/toolsets/general/CodeInsightToolset$SymbolInfoResult;", "", "symbolInfo", "Lcom/intellij/mcpserver/util/SymbolInfo;", "documentation", "", "<init>", "(Lcom/intellij/mcpserver/util/SymbolInfo;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/intellij/mcpserver/util/SymbolInfo;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSymbolInfo$annotations", "()V", "getSymbolInfo", "()Lcom/intellij/mcpserver/util/SymbolInfo;", "getDocumentation", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_mcpserver", "$serializer", "Companion", "intellij.mcpserver"})
    public static final class SymbolInfoResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final SymbolInfo symbolInfo;
        @NotNull
        private final String documentation;

        public SymbolInfoResult(@Nullable SymbolInfo symbolInfo, @NotNull String documentation) {
            Intrinsics.checkNotNullParameter((Object)documentation, (String)"documentation");
            this.symbolInfo = symbolInfo;
            this.documentation = documentation;
        }

        public /* synthetic */ SymbolInfoResult(SymbolInfo symbolInfo, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                symbolInfo = null;
            }
            this(symbolInfo, string);
        }

        @Nullable
        public final SymbolInfo getSymbolInfo() {
            return this.symbolInfo;
        }

        @EncodeDefault(mode=EncodeDefault.Mode.NEVER)
        public static /* synthetic */ void getSymbolInfo$annotations() {
        }

        @NotNull
        public final String getDocumentation() {
            return this.documentation;
        }

        @Nullable
        public final SymbolInfo component1() {
            return this.symbolInfo;
        }

        @NotNull
        public final String component2() {
            return this.documentation;
        }

        @NotNull
        public final SymbolInfoResult copy(@Nullable SymbolInfo symbolInfo, @NotNull String documentation) {
            Intrinsics.checkNotNullParameter((Object)documentation, (String)"documentation");
            return new SymbolInfoResult(symbolInfo, documentation);
        }

        public static /* synthetic */ SymbolInfoResult copy$default(SymbolInfoResult symbolInfoResult, SymbolInfo symbolInfo, String string, int n, Object object) {
            if ((n & 1) != 0) {
                symbolInfo = symbolInfoResult.symbolInfo;
            }
            if ((n & 2) != 0) {
                string = symbolInfoResult.documentation;
            }
            return symbolInfoResult.copy(symbolInfo, string);
        }

        @NotNull
        public String toString() {
            return "SymbolInfoResult(symbolInfo=" + this.symbolInfo + ", documentation=" + this.documentation + ")";
        }

        public int hashCode() {
            int result = this.symbolInfo == null ? 0 : this.symbolInfo.hashCode();
            result = result * 31 + this.documentation.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SymbolInfoResult)) {
                return false;
            }
            SymbolInfoResult symbolInfoResult = (SymbolInfoResult)other;
            if (!Intrinsics.areEqual((Object)this.symbolInfo, (Object)symbolInfoResult.symbolInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.documentation, (Object)symbolInfoResult.documentation);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_mcpserver(SymbolInfoResult self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (self.symbolInfo != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)SymbolInfo$.serializer.INSTANCE, (Object)self.symbolInfo);
            }
            output.encodeStringElement(serialDesc, 1, self.documentation);
        }

        public /* synthetic */ SymbolInfoResult(int seen0, SymbolInfo symbolInfo, String documentation, SerializationConstructorMarker serializationConstructorMarker) {
            if (2 != (2 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)2, (SerialDescriptor)SymbolInfoResult$$serializer.INSTANCE.getDescriptor());
            }
            this.symbolInfo = (seen0 & 1) == 0 ? null : symbolInfo;
            this.documentation = documentation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/mcpserver/toolsets/general/CodeInsightToolset$SymbolInfoResult$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/mcpserver/toolsets/general/CodeInsightToolset$SymbolInfoResult;", "intellij.mcpserver"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<SymbolInfoResult> serializer() {
                return (KSerializer)SymbolInfoResult$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

