/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.taskModel;

import com.intellij.gradle.toolingExtension.impl.model.taskModel.DefaultGradleTaskModel;
import com.intellij.gradle.toolingExtension.impl.util.GradleObjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.process.JavaForkOptions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.GradleTaskModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.builder.ProjectExtensionsDataBuilderImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/gradle/toolingExtension/impl/model/taskModel/GradleTaskModelBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/AbstractModelBuilderService;", "<init>", "()V", "canBuild", "", "modelName", "", "buildAll", "", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "collectTasks", "", "Lorg/jetbrains/plugins/gradle/model/DefaultExternalTask;", "reportErrorMessage", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.gradle.toolingExtension.impl"})
@ApiStatus.Internal
public final class GradleTaskModelBuilder
extends AbstractModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)GradleTaskModel.class.getName());
    }

    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DefaultGradleTaskModel taskModel = new DefaultGradleTaskModel();
        taskModel.setTasks(this.collectTasks(project));
        return taskModel;
    }

    private final Map<String, DefaultExternalTask> collectTasks(Project project) {
        HashMap result = new HashMap();
        for (Task task : project.getTasks()) {
            DefaultExternalTask externalTask = new DefaultExternalTask();
            externalTask.setName(task.getName());
            externalTask.setQName(task.getPath());
            externalTask.setDescription(task.getDescription());
            externalTask.setGroup(GradleObjectUtil.notNull(task.getGroup(), "other"));
            externalTask.setJvm(task instanceof JavaForkOptions);
            boolean isInternalTest = GradleTaskUtil.getBooleanProperty(task, "idea.internal.test", false);
            boolean isEffectiveTest = Intrinsics.areEqual((Object)"check", (Object)task.getName()) && Intrinsics.areEqual((Object)"verification", (Object)task.getGroup());
            boolean isJvmTest = task instanceof Test;
            boolean isAbstractTest = task instanceof AbstractTestTask;
            externalTask.setTest(isJvmTest || isAbstractTest || isInternalTest || isEffectiveTest);
            externalTask.setJvmTest(isJvmTest || isAbstractTest);
            externalTask.setInherited(false);
            externalTask.setType(ProjectExtensionsDataBuilderImpl.Companion.getType(task));
            ((Map)result).put(externalTask.getName(), externalTask);
        }
        return result;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.taskModel.group").withKind(Message.Kind.WARNING).withTitle("Gradle task model building failure").withException(exception).reportMessage(project);
    }
}

