/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.builder.ModelBuilderFactory;
import com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.library.ClassLoaderLibrary;
import com.thoughtworks.qdox.library.ClassNameLibrary;
import com.thoughtworks.qdox.library.ErrorHandler;
import com.thoughtworks.qdox.library.SourceFolderLibrary;
import com.thoughtworks.qdox.library.SourceLibrary;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.writer.ModelWriterFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public class OrderedClassLibraryBuilder
implements ClassLibraryBuilder {
    private AbstractClassLibrary classLibrary;
    private boolean debugLexer;
    private boolean debugParser;
    private String encoding;
    private ErrorHandler errorHandler;
    private ModelBuilderFactory modelBuilderFactory;
    private ModelWriterFactory modelWriterFactory;

    public OrderedClassLibraryBuilder() {
        this.classLibrary = new ClassNameLibrary();
    }

    public OrderedClassLibraryBuilder(AbstractClassLibrary rootClassLibrary) {
        this.classLibrary = rootClassLibrary;
    }

    @Override
    public ClassLibraryBuilder appendClassLoader(ClassLoader classLoader) {
        if (!(this.classLibrary instanceof ClassLoaderLibrary)) {
            this.classLibrary = this.newClassLoaderLibrary(this.classLibrary);
        }
        ClassLoaderLibrary classLoaderLibrary = (ClassLoaderLibrary)this.classLibrary;
        classLoaderLibrary.addClassLoader(classLoader);
        classLoaderLibrary.setModelBuilderFactory(this.modelBuilderFactory);
        classLoaderLibrary.setModelWriterFactory(this.modelWriterFactory);
        classLoaderLibrary.setDebugLexer(this.debugLexer);
        classLoaderLibrary.setDebugParser(this.debugParser);
        classLoaderLibrary.setErrorHandler(this.errorHandler);
        return this;
    }

    @Override
    public ClassLibraryBuilder appendDefaultClassLoaders() {
        if (!(this.classLibrary instanceof ClassLoaderLibrary)) {
            this.classLibrary = this.newClassLoaderLibrary(this.classLibrary);
        }
        ClassLoaderLibrary classLoaderLibrary = (ClassLoaderLibrary)this.classLibrary;
        classLoaderLibrary.addDefaultLoader();
        classLoaderLibrary.setModelBuilderFactory(this.modelBuilderFactory);
        classLoaderLibrary.setModelWriterFactory(this.modelWriterFactory);
        return this;
    }

    @Override
    public ClassLibraryBuilder appendSourceFolder(File sourceFolder) {
        if (!(this.classLibrary instanceof SourceFolderLibrary)) {
            this.classLibrary = this.newSourceFolderLibrary(this.classLibrary);
        }
        SourceFolderLibrary sourceFolderLibrary = (SourceFolderLibrary)this.classLibrary;
        this.prepareSourceLibrary(sourceFolderLibrary);
        sourceFolderLibrary.addSourceFolder(sourceFolder);
        return this;
    }

    @Override
    public ClassLibraryBuilder appendSource(InputStream stream) throws IOException {
        SourceLibrary sourceLibrary = this.getSourceLibrary();
        sourceLibrary.addSource(stream);
        return this;
    }

    @Override
    public ClassLibraryBuilder appendSource(Reader reader) {
        SourceLibrary sourceLibrary = this.getSourceLibrary();
        sourceLibrary.addSource(reader);
        return this;
    }

    @Override
    public ClassLibraryBuilder setDebugLexer(boolean debugLexer) {
        this.debugLexer = debugLexer;
        return this;
    }

    @Override
    public ClassLibraryBuilder setDebugParser(boolean debugParser) {
        this.debugParser = debugParser;
        return this;
    }

    @Override
    public ClassLibraryBuilder setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @Override
    public ClassLibraryBuilder setErrorHander(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public ClassLibraryBuilder setModelBuilderFactory(ModelBuilderFactory modelBuilderFactory) {
        this.modelBuilderFactory = modelBuilderFactory;
        return this;
    }

    @Override
    public ClassLibraryBuilder setModelWriterFactory(ModelWriterFactory modelWriterFactory) {
        this.modelWriterFactory = modelWriterFactory;
        return this;
    }

    @Override
    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    @Override
    public ClassLibraryBuilder appendSource(URL url) throws IOException {
        SourceLibrary sourceLibrary = this.getSourceLibrary();
        sourceLibrary.addSource(url);
        return this;
    }

    @Override
    public ClassLibraryBuilder appendSource(File file) throws IOException {
        SourceLibrary sourceLibrary = this.getSourceLibrary();
        sourceLibrary.addSource(file);
        return this;
    }

    @Override
    public JavaSource addSource(InputStream stream) throws IOException {
        SourceLibrary sourceLibrary = this.getSourceLibrary();
        return sourceLibrary.addSource(stream);
    }

    @Override
    public JavaSource addSource(Reader reader) {
        SourceLibrary sourceLibrary = this.getSourceLibrary();
        return sourceLibrary.addSource(reader);
    }

    @Override
    public JavaSource addSource(URL url) throws IOException {
        SourceLibrary sourceLibrary = this.getSourceLibrary();
        return sourceLibrary.addSource(url);
    }

    @Override
    public JavaSource addSource(File file) throws IOException {
        SourceLibrary sourceLibrary = this.getSourceLibrary();
        return sourceLibrary.addSource(file);
    }

    @Override
    public JavaModule addSourceFolder(File sourceFolder) {
        SourceFolderLibrary sourceFolderLibrary = this.getSourceFolderLibrary();
        return sourceFolderLibrary.addSourceFolder(sourceFolder);
    }

    private void prepareSourceLibrary(SourceLibrary sourceLibrary) {
        sourceLibrary.setModelBuilderFactory(this.modelBuilderFactory);
        sourceLibrary.setModelWriterFactory(this.modelWriterFactory);
        sourceLibrary.setDebugLexer(this.debugLexer);
        sourceLibrary.setDebugParser(this.debugParser);
        sourceLibrary.setEncoding(this.encoding);
        sourceLibrary.setErrorHandler(this.errorHandler);
    }

    protected final SourceLibrary getSourceLibrary() {
        if (!(this.classLibrary instanceof SourceLibrary)) {
            this.classLibrary = this.newSourceLibrary(this.classLibrary);
        }
        SourceLibrary sourceLibrary = (SourceLibrary)this.classLibrary;
        this.prepareSourceLibrary(sourceLibrary);
        return sourceLibrary;
    }

    private SourceFolderLibrary getSourceFolderLibrary() {
        if (!(this.classLibrary instanceof SourceFolderLibrary)) {
            this.classLibrary = this.newSourceFolderLibrary(this.classLibrary);
        }
        SourceFolderLibrary library = (SourceFolderLibrary)this.classLibrary;
        this.prepareSourceLibrary(library);
        return library;
    }

    protected ClassLoaderLibrary newClassLoaderLibrary(AbstractClassLibrary parentLibrary) {
        return new ClassLoaderLibrary(parentLibrary);
    }

    protected SourceLibrary newSourceLibrary(AbstractClassLibrary parentLibrary) {
        return new SourceLibrary(parentLibrary);
    }

    protected SourceFolderLibrary newSourceFolderLibrary(AbstractClassLibrary parentLibrary) {
        return new SourceFolderLibrary(parentLibrary);
    }
}

