/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zstd;

import java.io.IOException;
import javax.inject.Named;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;
import org.codehaus.plexus.archiver.zstd.ZstdCompressor;

@Named(value="zst")
public class ZstdArchiver
extends AbstractArchiver {
    private final ZstdCompressor compressor = new ZstdCompressor();

    public void setLevel(Integer level) throws ArchiverException {
        this.compressor.setLevel(level);
    }

    @Override
    protected void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        ResourceIterator iter = this.getResources();
        if (!iter.hasNext()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        ArchiveEntry entry = iter.next();
        if (iter.hasNext()) {
            throw new ArchiverException("There is more than one file in input.");
        }
        this.compressor.setSource(entry.getResource());
        this.compressor.setDestFile(this.getDestFile());
        this.compressor.compress();
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    protected void close() throws IOException {
        this.compressor.close();
    }

    @Override
    protected String getArchiveType() {
        return "zstd";
    }
}

