/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.shared.ref;

import com.intellij.vcs.git.shared.repo.GitRepositoryModel;
import git4idea.GitStandardLocalBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\b\b\u0001\u0010\t\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ(\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\r\"\u0004\b\u0000\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\r0\u0017H\u0002R\u0019\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/git/shared/ref/GitRefUtil;", "", "<init>", "()V", "knownPrefixes", "", "", "Lorg/jetbrains/annotations/NonNls;", "stripRefsPrefix", "refName", "getCommonCurrentBranch", "Lgit4idea/GitStandardLocalBranch;", "repositories", "", "Lcom/intellij/vcs/git/shared/repo/GitRepositoryModel;", "getCommonLocalBranches", "getCommonRemoteBranches", "Lgit4idea/GitStandardRemoteBranch;", "getCommonTags", "Lgit4idea/GitTag;", "findCommon", "T", "collections", "Lkotlin/sequences/Sequence;", "intellij.vcs.git.shared"})
@SourceDebugExtension(value={"SMAP\nGitRefUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRefUtil.kt\ncom/intellij/vcs/git/shared/ref/GitRefUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,40:1\n1563#2:41\n1634#2,3:42\n2322#3,7:45\n*S KotlinDebug\n*F\n+ 1 GitRefUtil.kt\ncom/intellij/vcs/git/shared/ref/GitRefUtil\n*L\n24#1:41\n24#1:42,3\n39#1:45,7\n*E\n"})
public final class GitRefUtil {
    @NotNull
    public static final GitRefUtil INSTANCE = new GitRefUtil();
    @NotNull
    private static final List<String> knownPrefixes;

    private GitRefUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String stripRefsPrefix(@NonNls @NotNull String refName) {
        Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
        for (String prefix : knownPrefixes) {
            if (!StringsKt.startsWith$default((String)refName, (String)prefix, (boolean)false, (int)2, null)) continue;
            String string = refName.substring(prefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return refName;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GitStandardLocalBranch getCommonCurrentBranch(@NotNull Collection<? extends GitRepositoryModel> repositories) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Iterable $this$map$iv = repositories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitRepositoryModel gitRepositoryModel = (GitRepositoryModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getState().getCurrentBranch());
        }
        return (GitStandardLocalBranch)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    public final Collection<GitStandardLocalBranch> getCommonLocalBranches(@NotNull Collection<? extends GitRepositoryModel> repositories) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        return this.findCommon(SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)repositories), GitRefUtil::getCommonLocalBranches$lambda$1));
    }

    @NotNull
    public final Collection<GitStandardRemoteBranch> getCommonRemoteBranches(@NotNull Collection<? extends GitRepositoryModel> repositories) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        return this.findCommon(SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)repositories), GitRefUtil::getCommonRemoteBranches$lambda$2));
    }

    @NotNull
    public final Collection<GitTag> getCommonTags(@NotNull Collection<? extends GitRepositoryModel> repositories) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        return this.findCommon(SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)repositories), GitRefUtil::getCommonTags$lambda$3));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Collection<T> findCommon(Sequence<? extends Collection<? extends T>> collections) {
        Collection collection;
        if (SequencesKt.none(collections)) {
            collection = CollectionsKt.emptyList();
        } else {
            Sequence<? extends Collection<? extends T>> $this$reduce$iv = collections;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty sequence can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void set;
                Collection collection2 = (Collection)iterator$iv.next();
                Collection acc = (Collection)accumulator$iv;
                boolean bl = false;
                accumulator$iv = CollectionsKt.intersect((Iterable)acc, (Iterable)((Iterable)set));
            }
            collection = (Collection)accumulator$iv;
        }
        return collection;
    }

    private static final Set getCommonLocalBranches$lambda$1(GitRepositoryModel repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        return repository2.getState().getLocalBranches();
    }

    private static final Set getCommonRemoteBranches$lambda$2(GitRepositoryModel repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        return repository2.getState().getRemoteBranches();
    }

    private static final Set getCommonTags$lambda$3(GitRepositoryModel repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        return repository2.getState().getTags();
    }

    static {
        Object[] objectArray = new String[]{"refs/heads/", "refs/remotes/", "refs/tags/"};
        knownPrefixes = CollectionsKt.listOf((Object[])objectArray);
    }
}

