/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.lang.jvm.JvmLong;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmValue;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.GroovyCreateFieldFromUsageHelper;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldActionKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.MyTemplateListener;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010(\u001a\u00020&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/GroovyFieldRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "constantField", "", "targetClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;ZLorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateFieldRequest;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConstantField", "()Z", "getTargetClass", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "helper", "Lorg/jetbrains/plugins/groovy/annotator/intentions/GroovyCreateFieldFromUsageHelper;", "getHelper", "()Lorg/jetbrains/plugins/groovy/annotator/intentions/GroovyCreateFieldFromUsageHelper;", "typeConstraints", "", "Lorg/jetbrains/plugins/groovy/lang/psi/expectedTypes/TypeConstraint;", "getTypeConstraints", "()[Lorg/jetbrains/plugins/groovy/lang/psi/expectedTypes/TypeConstraint;", "[Lorg/jetbrains/plugins/groovy/lang/psi/expectedTypes/TypeConstraint;", "modifiersToRender", "", "Lcom/intellij/lang/jvm/JvmModifier;", "getModifiersToRender", "()Ljava/util/Collection;", "doRender", "", "renderField", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "insertField", "field", "startTemplate", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nCreateFieldAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateFieldAction.kt\norg/jetbrains/plugins/groovy/annotator/intentions/elements/GroovyFieldRenderer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n37#2:158\n36#2,3:159\n1563#3:162\n1634#3,3:163\n*S KotlinDebug\n*F\n+ 1 CreateFieldAction.kt\norg/jetbrains/plugins/groovy/annotator/intentions/elements/GroovyFieldRenderer\n*L\n70#1:158\n70#1:159,3\n112#1:162\n112#1:163,3\n*E\n"})
final class GroovyFieldRenderer {
    @NotNull
    private final Project project;
    private final boolean constantField;
    @NotNull
    private final GrTypeDefinition targetClass;
    @NotNull
    private final CreateFieldRequest request;
    @NotNull
    private final GroovyCreateFieldFromUsageHelper helper;
    @NotNull
    private final TypeConstraint[] typeConstraints;

    public GroovyFieldRenderer(@NotNull Project project, boolean constantField, @NotNull GrTypeDefinition targetClass, @NotNull CreateFieldRequest request) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.project = project;
        this.constantField = constantField;
        this.targetClass = targetClass;
        this.request = request;
        this.helper = new GroovyCreateFieldFromUsageHelper();
        List list = this.request.getFieldType();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFieldType(...)");
        Collection $this$toTypedArray$iv = JvmPsiUtilKt.createConstraints(this.project, list);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.typeConstraints = thisCollection$iv.toArray(new TypeConstraint[0]);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getConstantField() {
        return this.constantField;
    }

    @NotNull
    public final GrTypeDefinition getTargetClass() {
        return this.targetClass;
    }

    @NotNull
    public final CreateFieldRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final GroovyCreateFieldFromUsageHelper getHelper() {
        return this.helper;
    }

    @NotNull
    public final TypeConstraint[] getTypeConstraints() {
        return this.typeConstraints;
    }

    private final Collection<JvmModifier> getModifiersToRender() {
        Collection collection;
        if (this.constantField) {
            List list;
            if (this.targetClass.isInterface()) {
                Collection collection2 = this.request.getModifiers();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getModifiers(...)");
                list = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)collection2, (Iterable)CreateFieldActionKt.getConstantModifiers()), (Iterable)JvmPsiUtilKt.getVisibilityModifiers());
            } else {
                Collection collection3 = this.request.getModifiers();
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"getModifiers(...)");
                list = CollectionsKt.plus((Collection)collection3, (Iterable)CreateFieldActionKt.getConstantModifiers());
            }
            collection = list;
        } else {
            Collection collection4 = this.request.getModifiers();
            Intrinsics.checkNotNull((Object)collection4);
            collection = collection4;
        }
        return collection;
    }

    public final void doRender() {
        GrField field2 = this.renderField();
        field2 = this.insertField(field2);
        this.startTemplate(field2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GrField renderField() {
        JvmValue requestInitializer;
        void $this$mapTo$iv$iv;
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"getInstance(...)");
        GroovyPsiElementFactory elementFactory = groovyPsiElementFactory;
        GrField grField = elementFactory.createField(this.request.getFieldName(), (PsiType)PsiTypes.intType());
        Intrinsics.checkNotNullExpressionValue((Object)grField, (String)"createField(...)");
        GrField field2 = grField;
        GrModifierList grModifierList = field2.getModifierList();
        if (grModifierList != null) {
            GrModifierList list = grModifierList;
            boolean bl = false;
            PsiElement psiElement = list.getFirstChild();
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl2 = false;
                list.deleteChildRange(it, list.getLastChild());
            }
        }
        for (AnnotationRequest annotation : this.request.getAnnotations()) {
            GrModifierList grModifierList2 = field2.getModifierList();
            if (grModifierList2 == null) continue;
            grModifierList2.addAnnotation(annotation.getQualifiedName());
        }
        Iterable $this$map$iv = this.getModifiersToRender();
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            JvmModifier jvmModifier = (JvmModifier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(JvmPsiUtilKt.toPsiModifier((JvmModifier)p0));
        }
        for (String modifier : (List)destination$iv$iv) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiModifierListOwner)field2), (String)modifier, (boolean)true);
        }
        if (this.targetClass instanceof GroovyScriptClass) {
            GrModifierList grModifierList3 = field2.getModifierList();
            if (grModifierList3 != null) {
                grModifierList3.addAnnotation("groovy.transform.Field");
            }
        }
        if (this.constantField) {
            field2.setInitializerGroovy(elementFactory.createExpressionFromText("0", null));
        }
        if ((requestInitializer = this.request.getInitializer()) instanceof JvmLong) {
            field2.setInitializerGroovy(elementFactory.createExpressionFromText(((JvmLong)requestInitializer).getLongValue() + "L", null));
        }
        return field2;
    }

    private final GrField insertField(GrField field2) {
        GrField grField = this.helper.insertFieldImpl(this.targetClass, field2, null);
        Intrinsics.checkNotNullExpressionValue((Object)grField, (String)"insertFieldImpl(...)");
        return grField;
    }

    private final void startTemplate(GrField field2) {
        PsiFile psiFile = this.targetClass.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile targetFile = psiFile;
        Editor editor = CodeInsightUtil.positionCursor((Project)field2.getProject(), (PsiFile)targetFile, (PsiElement)field2);
        if (editor == null) {
            return;
        }
        Editor newEditor = editor;
        JvmSubstitutor jvmSubstitutor = this.request.getTargetSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)jvmSubstitutor, (String)"getTargetSubstitutor(...)");
        PsiSubstitutor substitutor = JvmPsiUtilKt.toPsiSubstitutor(jvmSubstitutor, this.project);
        Template template = this.helper.setupTemplateImpl(field2, this.typeConstraints, this.targetClass, newEditor, null, this.constantField, this.request.isStartTemplate(), substitutor);
        MyTemplateListener listener = new MyTemplateListener(this.project, newEditor, targetFile);
        CreateFromUsageBaseFix.startTemplate((Editor)newEditor, (Template)template, (Project)this.project, (TemplateEditingListener)((TemplateEditingListener)listener), null);
    }
}

