/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;

public abstract class AbstractDependencyImpl<T extends DependencyMetadata<T>>
implements DependencyMetadata<T> {
    private final ModuleIdentifier moduleIdentifier;
    private final MutableVersionConstraint versionConstraint;
    private String reason;
    private AttributeContainer attributes = ImmutableAttributes.EMPTY;

    public AbstractDependencyImpl(String group, String name, String version) {
        this.moduleIdentifier = DefaultModuleIdentifier.newId(group, name);
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    public String getName() {
        return this.moduleIdentifier.getName();
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public ModuleIdentifier getModule() {
        return this.moduleIdentifier;
    }

    public T version(Action<? super MutableVersionConstraint> configureAction) {
        configureAction.execute((Object)this.versionConstraint);
        return (T)((DependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public T attributes(Action<? super AttributeContainer> configureAction) {
        configureAction.execute((Object)this.attributes);
        return (T)((DependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public String getReason() {
        return this.reason;
    }

    public T because(String reason) {
        this.reason = reason;
        return (T)((DependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public void setAttributes(AttributeContainer attributes) {
        this.attributes = attributes;
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.getGroup() + ":" + this.getName() + ":" + this.getVersionConstraint();
    }
}

