/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.resolve.LocalLibraryResolver;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.VariantComponent;
import org.gradle.platform.base.VariantComponentSpec;

public class DefaultLocalLibraryResolver
implements LocalLibraryResolver {
    private static final ModelType<ModelMap<ComponentSpec>> COMPONENT_MAP_TYPE = ModelTypes.modelMap(ComponentSpec.class);

    @Override
    public Collection<VariantComponent> resolveCandidates(ModelRegistry projectModel, String libraryName) {
        ArrayList<VariantComponent> librarySpecs = new ArrayList<VariantComponent>();
        this.collectLocalComponents(projectModel, "components", librarySpecs);
        this.collectLocalComponents(projectModel, "testSuites", librarySpecs);
        if (librarySpecs.isEmpty()) {
            return Collections.emptyList();
        }
        return librarySpecs;
    }

    private void collectLocalComponents(ModelRegistry projectModel, String container, List<VariantComponent> librarySpecs) {
        ModelMap components = (ModelMap)projectModel.find(container, COMPONENT_MAP_TYPE);
        if (components != null) {
            ModelMap libraries = components.withType(VariantComponentSpec.class);
            librarySpecs.addAll(libraries.values());
        }
    }
}

