/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.tasks;

import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Describables;
import org.gradle.internal.jacoco.JacocoReportAction;
import org.gradle.internal.jacoco.JacocoReportsContainerImpl;
import org.gradle.testing.jacoco.tasks.JacocoReportBase;
import org.gradle.testing.jacoco.tasks.JacocoReportsContainer;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class JacocoReport
extends JacocoReportBase
implements Reporting<JacocoReportsContainer> {
    private final Property<String> projectName = this.getProject().getObjects().property(String.class);
    private final JacocoReportsContainer reports;

    public JacocoReport() {
        this.projectName.value((Object)this.getProject().getName()).disallowChanges();
        this.reports = (JacocoReportsContainer)this.getProject().getObjects().newInstance(JacocoReportsContainerImpl.class, new Object[]{Describables.quoted((Object)"Task", (Object)this.getIdentityPath())});
    }

    @Input
    public Property<String> getReportProjectName() {
        return this.projectName;
    }

    @Nested
    public JacocoReportsContainer getReports() {
        return this.reports;
    }

    public JacocoReportsContainer reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public JacocoReportsContainer reports(Action<? super JacocoReportsContainer> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public void generate() {
        WorkQueue queue = this.getWorkerExecutor().classLoaderIsolation();
        queue.submit(JacocoReportAction.class, parameters -> {
            parameters.getAntLibraryClasspath().convention((Iterable)this.getJacocoClasspath());
            parameters.getProjectName().convention(this.getReportProjectName());
            parameters.getEncoding().convention(this.getSourceEncoding());
            parameters.getAllSourcesDirs().convention((Iterable)this.getAllSourceDirs());
            parameters.getAllClassesDirs().convention((Iterable)this.getAllClassDirs());
            parameters.getExecutionData().convention((Iterable)this.getExecutionData());
            parameters.getGenerateHtml().convention((Provider)this.reports.getHtml().getRequired());
            parameters.getHtmlDestination().convention((Provider)this.reports.getHtml().getOutputLocation());
            parameters.getGenerateXml().convention((Provider)this.reports.getXml().getRequired());
            parameters.getXmlDestination().convention((Provider)this.reports.getXml().getOutputLocation());
            parameters.getGenerateCsv().convention((Provider)this.reports.getCsv().getRequired());
            parameters.getCsvDestination().convention((Provider)this.reports.getCsv().getOutputLocation());
        });
    }
}

