/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.compiler.java.listeners.classnames;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;

public class ClassNameCollector
implements TaskListener {
    private final Map<File, Optional<String>> relativePaths = new HashMap<File, Optional<String>>();
    private final Consumer<String> classBackupService;
    private final Map<String, Set<String>> mapping = new HashMap<String, Set<String>>();
    private final Function<File, Optional<String>> relativize;
    private final Elements elements;

    public ClassNameCollector(Function<File, Optional<String>> relativize, Consumer<String> classBackupService, Elements elements) {
        this.relativize = relativize;
        this.classBackupService = classBackupService;
        this.elements = elements;
    }

    public Map<String, Set<String>> getMapping() {
        return this.mapping;
    }

    @Override
    public void started(TaskEvent e) {
        JavaFileObject sourceFile = e.getSourceFile();
        if (ClassNameCollector.isSourceFile(sourceFile)) {
            File asSourceFile = new File(sourceFile.getName());
            if (ClassNameCollector.isClassGenerationPhase(e)) {
                this.processSourceFile(e, asSourceFile);
            } else if (ClassNameCollector.isPackageInfoFile(e, asSourceFile)) {
                this.processPackageInfo(asSourceFile);
            }
        }
    }

    @Override
    public void finished(TaskEvent e) {
    }

    private static boolean isSourceFile(JavaFileObject sourceFile) {
        return sourceFile != null && sourceFile.getKind() == JavaFileObject.Kind.SOURCE;
    }

    private void processSourceFile(TaskEvent e, File sourceFile) {
        Optional<String> relativePath = this.findRelativePath(sourceFile);
        if (relativePath.isPresent()) {
            String key = relativePath.get();
            String symbol = this.normalizeName(e.getTypeElement());
            this.registerMapping(key, symbol);
            this.classBackupService.accept(symbol);
        }
    }

    private void processPackageInfo(File sourceFile) {
        Optional<String> relativePath = this.findRelativePath(sourceFile);
        if (relativePath.isPresent()) {
            String key = relativePath.get();
            String pkgInfo = key.substring(0, key.lastIndexOf(".java")).replace('/', '.');
            this.registerMapping(key, pkgInfo);
        }
    }

    private Optional<String> findRelativePath(File asSourceFile) {
        return this.relativePaths.computeIfAbsent(asSourceFile, this.relativize);
    }

    private String normalizeName(TypeElement typeElement) {
        String symbol = typeElement.getQualifiedName().toString();
        if (symbol.endsWith("module-info")) {
            symbol = "module-info";
        } else if (typeElement.getNestingKind().isNested()) {
            symbol = this.elements.getBinaryName(typeElement).toString();
        }
        return symbol;
    }

    private static boolean isPackageInfoFile(TaskEvent e, File asSourceFile) {
        return e.getKind() == TaskEvent.Kind.ANALYZE && "package-info.java".equals(asSourceFile.getName());
    }

    private static boolean isClassGenerationPhase(TaskEvent e) {
        return e.getKind() == TaskEvent.Kind.GENERATE;
    }

    public void registerMapping(String key, String symbol) {
        Collection symbols = this.mapping.computeIfAbsent(key, k -> new TreeSet());
        symbols.add(symbol);
    }
}

