/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeMarkupable;
import ghidra.app.util.bin.format.pe.cli.CliStreamHeader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamGuid;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamStrings;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamUserStrings;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class CliMetadataRoot
implements StructConverter,
PeMarkupable {
    public static final String NAME = "CLI_METADATA_HEADER";
    public static final String PATH = "/PE/CLI";
    private BinaryReader reader;
    private long fileOffset;
    private int rva;
    private int signature;
    private short majorVersion;
    private short minorVersion;
    private int reserved;
    private int versionLength;
    private String version;
    private short flags;
    private short streamsCount;
    private Map<String, CliStreamHeader> streamHeaderMap;
    private CliStreamHeader metadataHeader;
    private CliStreamGuid guidStream;
    private CliStreamUserStrings userStringsStream;
    private CliStreamStrings stringsStream;
    private CliStreamBlob blobStream;
    private CliStreamMetadata metadataStream;

    public CliMetadataRoot(BinaryReader reader, int rva) throws IOException {
        this.reader = reader;
        this.fileOffset = reader.getPointerIndex();
        this.rva = rva;
        this.signature = reader.readNextInt();
        this.majorVersion = reader.readNextShort();
        this.minorVersion = reader.readNextShort();
        this.reserved = reader.readNextInt();
        this.versionLength = reader.readNextInt();
        if (this.versionLength > 0 && this.versionLength < 65536) {
            this.version = new String(reader.readNextByteArray(this.versionLength), Charset.forName("UTF-8"));
        }
        this.flags = reader.readNextShort();
        this.streamsCount = reader.readNextShort();
        this.streamHeaderMap = new LinkedHashMap<String, CliStreamHeader>();
        for (short i = 0; i < this.streamsCount; i = (short)(i + 1)) {
            CliStreamHeader streamHeader = new CliStreamHeader(this, reader);
            this.streamHeaderMap.put(streamHeader.getName(), streamHeader);
            if (!streamHeader.getName().equals(CliStreamMetadata.getName())) continue;
            this.metadataHeader = streamHeader;
        }
    }

    public boolean parse() throws IOException {
        boolean success = true;
        CliStreamHeader header = this.streamHeaderMap.get(CliStreamGuid.getName());
        if (header != null) {
            this.guidStream = new CliStreamGuid(header, this.getFileOffset() + (long)header.getOffset(), this.getRva() + header.getOffset(), this.reader);
            header.setStream(this.guidStream);
            success &= this.guidStream.parse();
        }
        if ((header = this.streamHeaderMap.get(CliStreamUserStrings.getName())) != null) {
            this.userStringsStream = new CliStreamUserStrings(header, this.getFileOffset() + (long)header.getOffset(), this.getRva() + header.getOffset(), this.reader);
            header.setStream(this.userStringsStream);
            success &= this.userStringsStream.parse();
        }
        if ((header = this.streamHeaderMap.get(CliStreamStrings.getName())) != null) {
            this.stringsStream = new CliStreamStrings(header, this.getFileOffset() + (long)header.getOffset(), this.getRva() + header.getOffset(), this.reader);
            header.setStream(this.stringsStream);
            success &= this.stringsStream.parse();
        }
        if ((header = this.streamHeaderMap.get(CliStreamBlob.getName())) != null) {
            this.blobStream = new CliStreamBlob(header, this.getFileOffset() + (long)header.getOffset(), this.getRva() + header.getOffset(), this.reader);
            header.setStream(this.blobStream);
            success &= this.blobStream.parse();
        }
        if ((header = this.streamHeaderMap.get(CliStreamMetadata.getName())) != null) {
            this.metadataStream = new CliStreamMetadata(header, this.guidStream, this.userStringsStream, this.stringsStream, this.blobStream, this.getFileOffset() + (long)header.getOffset(), this.getRva() + header.getOffset(), this.reader);
            header.setStream(this.metadataStream);
            success &= this.metadataStream.parse();
        }
        return success;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException, MemoryAccessException {
        Address start = program.getImageBase().add((long)this.getRva());
        try {
            program.getSymbolTable().createLabel(start, NAME, SourceType.ANALYSIS);
        }
        catch (InvalidInputException e) {
            Msg.warn((Object)this, (Object)"Invalid symbol name: \"CLI_METADATA_HEADER\"");
        }
        for (CliStreamHeader header : this.streamHeaderMap.values()) {
            if (header == this.metadataHeader) continue;
            header.markup(program, isBinary, monitor, log, ntHeader);
        }
        if (this.metadataHeader != null) {
            this.metadataHeader.markup(program, isBinary, monitor, log, ntHeader);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(new CategoryPath(PATH));
        struct.add(DWORD, "Signature", "must be 0x424a5342");
        struct.add(WORD, "MajorVersion", null);
        struct.add(WORD, "MinorVersion", null);
        struct.add(DWORD, "Reserved", "should be 0");
        struct.add(DWORD, "VersionLength", null);
        struct.add((DataType)new ArrayDataType((DataType)CharDataType.dataType, this.versionLength, 1), "Version", null);
        struct.add(WORD, "Flags", "should be 0");
        struct.add(WORD, "StreamsCount", "number of stream headers to follow");
        for (CliStreamHeader hdr : this.streamHeaderMap.values()) {
            struct.add(hdr.toDataType(), hdr.getName(), null);
        }
        return struct;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public int getRva() {
        return this.rva;
    }

    public int getSignature() {
        return this.signature;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getVersionLength() {
        return this.versionLength;
    }

    public String getVersion() {
        return this.version;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getStreamsCount() {
        return this.streamsCount;
    }

    public CliStreamGuid getGuidStream() {
        return this.guidStream;
    }

    public CliStreamUserStrings getUserStringsStream() {
        return this.userStringsStream;
    }

    public CliStreamStrings getStringsStream() {
        return this.stringsStream;
    }

    public CliStreamBlob getBlobStream() {
        return this.blobStream;
    }

    public CliStreamMetadata getMetadataStream() {
        return this.metadataStream;
    }

    public Collection<CliStreamHeader> getStreamHeaders() {
        return this.streamHeaderMap.values();
    }

    public CliStreamHeader getStreamHeader(String name) {
        return this.streamHeaderMap.get(name);
    }

    public int getBlobOffsetAtIndex(int index) {
        CliStreamHeader blobHdr = this.getStreamHeader("#Blob");
        if (blobHdr == null) {
            return -1;
        }
        int offset = (int)this.fileOffset + blobHdr.getOffset() + index;
        return offset;
    }
}

