/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import java.math.BigInteger;
import org.jdom.Element;

public class FieldLocation
implements Comparable<FieldLocation> {
    public static final FieldLocation MAX = new FieldLocation(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public int fieldNum;
    public int row;
    public int col;
    private BigInteger index;

    public FieldLocation() {
        this(BigInteger.ZERO, 0, 0, 0);
    }

    public FieldLocation(int index) {
        this(index, 0, 0, 0);
    }

    public FieldLocation(int index, int fieldNum) {
        this(index, fieldNum, 0, 0);
    }

    public FieldLocation(BigInteger index) {
        this(index, 0, 0, 0);
    }

    public FieldLocation(BigInteger index, int fieldNum) {
        this(index, fieldNum, 0, 0);
    }

    public FieldLocation(int index, int fieldNum, int row, int col) {
        this(BigInteger.valueOf(index), fieldNum, row, col);
    }

    public FieldLocation(BigInteger index, int fieldNum, int row, int col) {
        this.index = index;
        this.fieldNum = fieldNum;
        this.row = row;
        this.col = col;
    }

    public FieldLocation(Element child) {
        String bigIndexAttribute = child.getAttributeValue("B");
        if (bigIndexAttribute != null) {
            this.index = new BigInteger(bigIndexAttribute);
        } else {
            int value = Integer.parseInt(child.getAttributeValue("I"));
            this.index = BigInteger.valueOf(value);
        }
        this.fieldNum = Integer.parseInt(child.getAttributeValue("F"));
        this.row = Integer.parseInt(child.getAttributeValue("R"));
        this.col = Integer.parseInt(child.getAttributeValue("C"));
    }

    public FieldLocation(FieldLocation loc) {
        this(loc.index, loc.fieldNum, loc.row, loc.col);
    }

    public BigInteger getIndex() {
        return this.index;
    }

    public int getFieldNum() {
        return this.fieldNum;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLocation)) {
            return false;
        }
        FieldLocation loc = (FieldLocation)obj;
        return this.index.equals(loc.index) && this.fieldNum == loc.fieldNum && this.row == loc.row && this.col == loc.col;
    }

    @Override
    public int compareTo(FieldLocation o) {
        int compareTo = this.index.compareTo(o.index);
        if (compareTo != 0) {
            return compareTo;
        }
        if (this.fieldNum < o.fieldNum) {
            return -1;
        }
        if (this.fieldNum > o.fieldNum) {
            return 1;
        }
        if (this.row < o.row) {
            return -1;
        }
        if (this.row > o.row) {
            return 1;
        }
        if (this.col < o.col) {
            return -1;
        }
        if (this.col > o.col) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.index.intValue() + this.fieldNum * 100 + this.row * 10 + this.col;
    }

    public String toString() {
        return this.index.toString() + ", " + this.fieldNum + ", " + this.row + ", " + this.col;
    }

    public Element getElement(String name) {
        Element element = new Element(name);
        element.setAttribute("B", this.index.toString());
        element.setAttribute("F", Integer.toString(this.fieldNum));
        element.setAttribute("R", Integer.toString(this.row));
        element.setAttribute("C", Integer.toString(this.col));
        return element;
    }

    public void set(FieldLocation loc) {
        this.index = loc.index;
        this.fieldNum = loc.fieldNum;
        this.row = loc.row;
        this.col = loc.col;
    }

    public void setIndex(BigInteger index) {
        this.index = index;
    }
}

