/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockableComponent;
import docking.DockingWindowManager;
import docking.PlaceholderManager;
import docking.WindowPosition;
import generic.test.AbstractGTest;
import generic.test.AbstractGuiTest;
import java.awt.Point;
import java.awt.Window;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class DockingWindowManagerTestUtils {
    public static Set<ComponentProvider> getActiveProviders(DockingWindowManager dwm) {
        PlaceholderManager pm = dwm.getPlaceholderManager();
        return pm.getActiveProviders();
    }

    public static Window moveProviderToWindow(DockingWindowManager dwm, ComponentProvider provider) {
        AbstractGuiTest.runSwing(() -> {
            if (!dwm.containsProvider(provider)) {
                return;
            }
            ComponentPlaceholder placeholder = dwm.getActivePlaceholder(provider);
            DockableComponent dockingComponent = dwm.getDockableComponent(provider);
            Point point = new Point(0, 0);
            if (dockingComponent.isShowing()) {
                point = dockingComponent.getLocationOnScreen();
            }
            dwm.movePlaceholder(placeholder, point);
        });
        Window w = (Window)AbstractGTest.waitForValue(() -> dwm.getProviderWindow(provider));
        return w;
    }

    public static void moveProvider(DockingWindowManager dwm, ComponentProvider movee, ComponentProvider relativeTo, WindowPosition position) {
        AbstractGuiTest.runSwing(() -> {
            ComponentPlaceholder moveePlaceholder = dwm.getPlaceholder(movee);
            ComponentPlaceholder relativeToPlaceholder = dwm.getPlaceholder(relativeTo);
            dwm.movePlaceholder(moveePlaceholder, relativeToPlaceholder, position);
        });
    }

    public static DockableComponent getDockableComponent(DockingWindowManager dwm, ComponentProvider provider) {
        AtomicReference ref = new AtomicReference();
        AbstractGuiTest.runSwing(() -> ref.set(dwm.getDockableComponent(provider)));
        return (DockableComponent)ref.get();
    }
}

