/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockableComponent;
import docking.DockableHeader;
import docking.DockingWindowManager;
import docking.Node;
import docking.SplitNode;
import docking.WindowNode;
import docking.WindowPosition;
import docking.actions.KeyBindingUtils;
import docking.widgets.OptionDialog;
import docking.widgets.tabbedpane.DockingTabRenderer;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import help.HelpService;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.jdom.Content;
import org.jdom.Element;
import utilities.util.reflection.ReflectionUtilities;

class ComponentNode
extends Node {
    private ComponentPlaceholder top;
    private List<ComponentPlaceholder> windowPlaceholders;
    private JComponent comp;
    private boolean isDisposed;

    ComponentNode(DockingWindowManager windowManager) {
        super(windowManager);
        this.windowPlaceholders = new ArrayList<ComponentPlaceholder>();
    }

    ComponentNode(Element element, DockingWindowManager windowManager, Node parent, List<ComponentPlaceholder> restoredPlaceholders) {
        super(windowManager);
        this.parent = parent;
        this.windowPlaceholders = new ArrayList<ComponentPlaceholder>();
        int topIndex = Integer.parseInt(element.getAttributeValue("TOP_INFO"));
        List children = element.getChildren();
        for (Element e : children) {
            ComponentPlaceholder placeholder;
            String name = e.getAttributeValue("NAME");
            String owner = e.getAttributeValue("OWNER");
            String title = e.getAttributeValue("TITLE");
            String group = e.getAttributeValue("GROUP");
            if (group == null || group.trim().isEmpty()) {
                group = "Default";
            }
            boolean isActive = Boolean.valueOf(e.getAttributeValue("ACTIVE"));
            long uniqueID = this.getUniqueID(e, 0L);
            String mappedOwner = ComponentProvider.getMappedOwner(owner, name);
            if (mappedOwner != null) {
                name = ComponentProvider.getMappedName(owner, name);
                owner = mappedOwner;
            }
            if (this.containsPlaceholder(placeholder = new ComponentPlaceholder(name, owner, group, title, isActive, this, uniqueID))) continue;
            this.windowPlaceholders.add(placeholder);
            restoredPlaceholders.add(placeholder);
        }
        if (topIndex >= 0 && topIndex < this.windowPlaceholders.size()) {
            this.top = this.windowPlaceholders.get(topIndex);
        }
    }

    private void focusComponent(Component component) {
        if (component == null) {
            return;
        }
        ComponentPlaceholder placeholder = this.getPlaceHolderForComponent(component);
        if (placeholder != null) {
            placeholder.requestFocusWhenReady();
        }
    }

    private boolean containsPlaceholder(ComponentPlaceholder placeholder) {
        String group = placeholder.getGroup();
        if (group == null) {
            group = "";
        }
        String owner = placeholder.getOwner();
        String name = placeholder.getName();
        String title = placeholder.getTitle();
        for (ComponentPlaceholder existingPlaceholder : this.windowPlaceholders) {
            if (!existingPlaceholder.getOwner().equals(owner) || !existingPlaceholder.getName().equals(name) || !existingPlaceholder.getGroup().equals(group) || !existingPlaceholder.getTitle().equals(title)) continue;
            return true;
        }
        return false;
    }

    private long getUniqueID(Element e, long defaultValue) {
        String attributeValue = e.getAttributeValue("INSTANCE_ID");
        if (attributeValue == null) {
            return defaultValue;
        }
        return Long.parseLong(attributeValue);
    }

    @Override
    List<Node> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.printTree();
    }

    @Override
    String getDescription() {
        return this.windowPlaceholders.toString();
    }

    void add(ComponentPlaceholder placeholder) {
        this.windowPlaceholders.add(placeholder);
        placeholder.setNode(this);
        if (placeholder.isActive()) {
            this.top = placeholder;
            this.invalidate();
        }
        WindowNode topLevelNode = this.getTopLevelNode();
        topLevelNode.componentAdded(placeholder);
    }

    void remove(ComponentPlaceholder placeholder) {
        if (this.getTopLevelNode() == null) {
            return;
        }
        if (placeholder.isActive()) {
            if (this.top == placeholder) {
                this.top = null;
            }
            this.invalidate();
        }
        WindowNode topLevelNode = this.getTopLevelNode();
        topLevelNode.componentRemoved(placeholder);
        this.doRemove(placeholder);
    }

    private void doRemove(ComponentPlaceholder placeholder) {
        this.windowPlaceholders.remove(placeholder);
        placeholder.setNode(null);
        if (this.windowPlaceholders.isEmpty()) {
            this.parent.removeNode(this);
        }
    }

    void remove(ComponentPlaceholder placeholder, boolean keepEmptyPlaceholder) {
        if (placeholder.isActive()) {
            placeholder.show(false);
            if (this.top == placeholder) {
                this.top = null;
            }
            this.invalidate();
            this.winMgr.scheduleUpdate();
        }
        placeholder.setProvider(null);
        if (!keepEmptyPlaceholder) {
            this.doRemove(placeholder);
        }
    }

    @Override
    int getComponentCount() {
        ArrayList<ComponentPlaceholder> activeComponents = new ArrayList<ComponentPlaceholder>();
        this.populateActiveComponents(activeComponents);
        return activeComponents.size();
    }

    @Override
    void close() {
        ArrayList<ComponentPlaceholder> list = new ArrayList<ComponentPlaceholder>(this.windowPlaceholders);
        for (ComponentPlaceholder placeholder : list) {
            placeholder.close();
        }
    }

    @Override
    JComponent getComponent() {
        if (this.isDisposed) {
            throw new AssertException("Attempted to reuse a disposed component window node");
        }
        if (!this.invalid) {
            return this.comp;
        }
        if (this.comp instanceof JTabbedPane) {
            this.comp.removeAll();
        }
        this.comp = null;
        ArrayList<ComponentPlaceholder> activeComponents = new ArrayList<ComponentPlaceholder>();
        this.populateActiveComponents(activeComponents);
        int count = activeComponents.size();
        if (count == 1) {
            ComponentPlaceholder nextTop = (ComponentPlaceholder)activeComponents.get(0);
            if (nextTop.isDisposed()) {
                Msg.debug((Object)this, (Object)("Found disposed component that was not removed from the active list: " + String.valueOf(nextTop)), (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
                return null;
            }
            this.top = (ComponentPlaceholder)activeComponents.get(0);
            this.comp = this.top.getComponent();
            this.comp.setBorder(BorderFactory.createRaisedBevelBorder());
            this.installRenameMenu(this.top, null);
        } else if (count > 1) {
            JTabbedPane tabbedPane = new JTabbedPane(3, 1);
            this.setupFocusUpdateListeners(tabbedPane);
            this.comp = tabbedPane;
            int activeIndex = this.addComponentsToTabbedPane(activeComponents, tabbedPane);
            DockableComponent activeComp = (DockableComponent)tabbedPane.getComponentAt(activeIndex);
            this.top = activeComp.getComponentWindowingPlaceholder();
            tabbedPane.setSelectedComponent(activeComp);
        }
        this.invalid = false;
        return this.comp;
    }

    private int addComponentsToTabbedPane(List<ComponentPlaceholder> activeComponents, JTabbedPane tabbedPane) {
        int count = activeComponents.size();
        int activeIndex = 0;
        for (int i = 0; i < count; ++i) {
            ComponentPlaceholder placeholder = activeComponents.get(i);
            DockableComponent c = placeholder.getComponent();
            c.setBorder(BorderFactory.createEmptyBorder());
            String title = placeholder.getTitle();
            String tabText = placeholder.getTabText();
            DockableComponent component = placeholder.getComponent();
            tabbedPane.add((Component)component, title);
            DockingTabRenderer tabRenderer = this.createTabRenderer(tabbedPane, placeholder, title, tabText, component);
            c.installDragDropTarget(tabbedPane);
            tabbedPane.setTabComponentAt(i, tabRenderer);
            Icon icon = placeholder.getIcon();
            if (icon != null) {
                tabRenderer.setIcon(icon);
            }
            if (placeholder != this.top) continue;
            activeIndex = i;
        }
        return activeIndex;
    }

    private void setupFocusUpdateListeners(final JTabbedPane tabbedPane) {
        this.registerActionToTransferFocusToTabbedComponent(tabbedPane);
        tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = tabbedPane.indexAtLocation(e.getX(), e.getY());
                if (index >= 0) {
                    Component selectedComponent = tabbedPane.getComponentAt(index);
                    ComponentNode.this.focusComponent(selectedComponent);
                }
            }
        });
    }

    private void registerActionToTransferFocusToTabbedComponent(final JTabbedPane tabbedPane) {
        AbstractAction focusAction = new AbstractAction("Focus"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Component selectedComponent = tabbedPane.getSelectedComponent();
                ComponentNode.this.focusComponent(selectedComponent);
            }
        };
        KeyBindingUtils.registerAction((JComponent)tabbedPane, KeyStroke.getKeyStroke(32, 0), focusAction, 0);
    }

    private DockingTabRenderer createTabRenderer(JTabbedPane pane, ComponentPlaceholder placeholder, String title, String tabText, DockableComponent component) {
        DockingTabRenderer tabRenderer = new DockingTabRenderer(pane, title, tabText, e -> this.closeTab(component));
        this.installRenameMenu(placeholder, tabRenderer);
        return tabRenderer;
    }

    private void installRenameMenu(ComponentPlaceholder placeholder, DockingTabRenderer tabRenderer) {
        ComponentProvider provider = placeholder.getProvider();
        if (!provider.isTransient() || provider.isSnapshot()) {
            return;
        }
        RenameMouseListener listener = new RenameMouseListener(placeholder);
        DockableComponent dockableComponent = placeholder.getComponent();
        DockableHeader header = dockableComponent.getHeader();
        header.installRenameAction(listener);
        if (tabRenderer != null) {
            tabRenderer.installRenameAction(listener);
        }
    }

    @Override
    void populateActiveComponents(List<ComponentPlaceholder> list) {
        for (ComponentPlaceholder placeholder : this.windowPlaceholders) {
            if (!placeholder.isActive()) continue;
            list.add(placeholder);
        }
    }

    @Override
    void removeNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    void replaceNode(Node oldNode, Node newNode) {
    }

    void split(ComponentPlaceholder source, WindowPosition dropCode) {
        ComponentNode sourceNode = new ComponentNode(this.winMgr);
        source.setNode(sourceNode);
        Node parentNode = this.parent;
        parentNode.replaceNode(this, switch (dropCode) {
            case WindowPosition.LEFT -> new SplitNode(this.winMgr, sourceNode, (Node)this, true);
            case WindowPosition.RIGHT -> new SplitNode(this.winMgr, this, (Node)sourceNode, true);
            case WindowPosition.TOP -> new SplitNode(this.winMgr, sourceNode, (Node)this, false);
            case WindowPosition.BOTTOM -> new SplitNode(this.winMgr, this, (Node)sourceNode, false);
            default -> new SplitNode(this.winMgr, this, (Node)sourceNode, true);
        });
        sourceNode.add(source);
    }

    boolean isStacked() {
        return this.comp instanceof JTabbedPane;
    }

    public void makeSelectedTab(ComponentPlaceholder placeholder) {
        JTabbedPane tab;
        if (this.invalid) {
            return;
        }
        if (!(this.comp instanceof JTabbedPane)) {
            return;
        }
        DockableComponent dc = placeholder.getComponent();
        if (dc != null && (tab = (JTabbedPane)this.comp).getSelectedComponent() != dc) {
            tab.setSelectedComponent(dc);
        }
    }

    @Override
    Element saveToXML() {
        Element root = new Element("COMPONENT_NODE");
        int topIndex = 0;
        if (this.top != null) {
            for (int i = 0; i < this.windowPlaceholders.size(); ++i) {
                ComponentPlaceholder placeholder = this.windowPlaceholders.get(i);
                if (placeholder != this.top) continue;
                topIndex = i;
                break;
            }
        }
        root.setAttribute("TOP_INFO", "" + topIndex);
        for (ComponentPlaceholder placeholder : this.windowPlaceholders) {
            Element elem = new Element("COMPONENT_INFO");
            elem.setAttribute("NAME", placeholder.getName());
            elem.setAttribute("OWNER", placeholder.getOwner());
            elem.setAttribute("TITLE", placeholder.getTitle());
            elem.setAttribute("ACTIVE", "" + placeholder.isActive());
            elem.setAttribute("GROUP", placeholder.getGroup());
            elem.setAttribute("INSTANCE_ID", Long.toString(placeholder.getInstanceID()));
            root.addContent((Content)elem);
        }
        return root;
    }

    @Override
    boolean contains(ComponentPlaceholder placeholder) {
        for (ComponentPlaceholder ph : this.windowPlaceholders) {
            if (!ph.isActive() || !ph.equals(placeholder)) continue;
            return true;
        }
        return false;
    }

    void titleChanged(ComponentPlaceholder placeholder) {
        if (!(this.comp instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane pane = (JTabbedPane)this.comp;
        int index = pane.indexOfComponent(placeholder.getComponent());
        if (index == -1) {
            return;
        }
        DockingTabRenderer renderer = (DockingTabRenderer)pane.getTabComponentAt(index);
        renderer.setIcon(placeholder.getIcon());
        String tabText = placeholder.getTabText();
        String fullTitle = placeholder.getTitle();
        renderer.setTitle(tabText, fullTitle);
    }

    public void iconChanged(ComponentPlaceholder placeholder) {
        if (!(this.comp instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane pane = (JTabbedPane)this.comp;
        int index = pane.indexOfComponent(placeholder.getComponent());
        if (index == -1) {
            return;
        }
        DockingTabRenderer renderer = (DockingTabRenderer)pane.getTabComponentAt(index);
        renderer.setIcon(placeholder.getIcon());
        pane.setIconAt(index, placeholder.getIcon());
    }

    private void closeTab(Component tabComponent) {
        if (!(this.comp instanceof JTabbedPane)) {
            return;
        }
        ComponentPlaceholder placeholder = this.getPlaceHolderForComponent(tabComponent);
        if (placeholder != null) {
            placeholder.close();
        }
    }

    private ComponentPlaceholder getPlaceHolderForComponent(Component component) {
        for (ComponentPlaceholder placeholder : this.windowPlaceholders) {
            if (component != placeholder.getComponent()) continue;
            return placeholder;
        }
        return null;
    }

    @Override
    WindowNode getTopLevelNode() {
        if (this.parent != null) {
            return this.parent.getTopLevelNode();
        }
        return null;
    }

    @Override
    void dispose() {
        this.isDisposed = true;
        if (this.top != null) {
            this.top.dispose();
        }
        this.windowPlaceholders.clear();
    }

    private static class RenameMouseListener
    extends MouseAdapter {
        private static final HelpLocation RENAME_HELP = new HelpLocation("DockingWindows", "Renaming_Windows");
        private ComponentPlaceholder placeholder;

        RenameMouseListener(ComponentPlaceholder placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JMenuItem menuItem = new JMenuItem("Rename");
            menuItem.addActionListener(new RenameActionListener());
            HelpService helpService = DockingWindowManager.getHelpService();
            helpService.registerHelp((Object)menuItem, RENAME_HELP);
            JPopupMenu menu = new JPopupMenu();
            menu.add(menuItem);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }

        private class RenameActionListener
        implements ActionListener {
            private RenameActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                String currentTabText;
                ComponentProvider provider = RenameMouseListener.this.placeholder.getProvider();
                JComponent component = provider.getComponent();
                String newName = OptionDialog.showInputSingleLineDialog(component, "Rename Tab", "New name:", currentTabText = provider.getTabText());
                if (newName == null || newName.isEmpty()) {
                    return;
                }
                provider.setCustomTitle(newName);
                provider.setSubTitle("");
                provider.setCustomTabText(newName);
            }
        }
    }
}

