/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.util.ErrorHandler;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreKeySet;
import ghidra.util.database.DirectedIterator;
import ghidra.util.database.KeySpan;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;

public class DBCachedObjectStoreKeySubSet
extends DBCachedObjectStoreKeySet {
    protected final KeySpan keySpan;

    public DBCachedObjectStoreKeySubSet(DBCachedObjectStore<?> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction, KeySpan keySpan) {
        super(store, errHandler, lock, direction);
        this.keySpan = keySpan;
    }

    @Override
    public Long first() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.first(this.direction, this.keySpan));
    }

    @Override
    public Long last() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.last(this.direction, this.keySpan));
    }

    @Override
    public int size() {
        return this.store.getKeyCount(this.keySpan);
    }

    @Override
    public boolean isEmpty() {
        return !this.store.getKeysExist(this.keySpan);
    }

    @Override
    public boolean contains(Object o) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.contains(o, this.keySpan));
    }

    @Override
    public Object[] toArray() {
        return this.store.keys.toArray(this.direction, this.keySpan);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.store.keys.toArray(this.direction, this.keySpan, a, this.store.getKeyCount(this.keySpan));
    }

    @Override
    public boolean remove(Object o) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.keys.remove(o, this.keySpan));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.containsAll(c, this.keySpan));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.store.keys.retain(c, this.keySpan);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.keys.removeAll(c, this.keySpan));
    }

    @Override
    public void clear() {
        this.store.deleteKeys(this.keySpan);
    }

    @Override
    public Long lower(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.lower(this.direction, e, this.keySpan));
    }

    @Override
    public Long floor(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.floor(this.direction, e, this.keySpan));
    }

    @Override
    public Long ceiling(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.ceiling(this.direction, e, this.keySpan));
    }

    @Override
    public Long higher(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.higher(this.direction, e, this.keySpan));
    }

    @Override
    public Iterator<Long> iterator() {
        return this.store.keys.iterator(this.direction, this.keySpan);
    }

    @Override
    public DBCachedObjectStoreKeySubSet descendingSet() {
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction), this.keySpan);
    }

    @Override
    public Iterator<Long> descendingIterator() {
        return this.store.keys.iterator(DirectedIterator.Direction.reverse(this.direction), this.keySpan);
    }

    @Override
    public DBCachedObjectStoreKeySubSet subSet(Long fromElement, boolean fromInclusive, Long toElement, boolean toInclusive) {
        KeySpan span = KeySpan.sub(fromElement, fromInclusive, toElement, toInclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }

    @Override
    public DBCachedObjectStoreKeySubSet headSet(Long toElement, boolean inclusive) {
        KeySpan span = KeySpan.head(toElement, inclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }

    @Override
    public DBCachedObjectStoreKeySubSet tailSet(Long fromElement, boolean inclusive) {
        KeySpan span = KeySpan.tail(fromElement, inclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }
}

