/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.server;

import java.io.InputStream;
import java.lang.reflect.Method;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.ClientCallback;
import org.rzo.netty.ahessian.rpc.callback.ServerCallbackProxy;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.HessianSkeleton;
import org.rzo.netty.ahessian.rpc.server.ServiceSessionProvider;

public class ImmediateInvokeService
extends HessianSkeleton
implements Constants {
    public ImmediateInvokeService(Object service, Class apiClass, HessianRPCServiceHandler factory) {
        super(service, apiClass, factory);
    }

    @Override
    public void messageReceived(HessianRPCCallMessage message) {
        ServiceSessionProvider.set(message.getSession());
        ServiceSessionProvider.setHandler(message.getHandler());
        threadLocalChannel.set(message.getChannel());
        this.invoke(message);
        threadLocalChannel.remove();
        ServiceSessionProvider.remove();
        ServiceSessionProvider.removeHandler();
    }

    void invoke(HessianRPCCallMessage message) {
        Object result = null;
        Throwable fault = null;
        try {
            Method method = this.getMethod(message);
            Object[] args = message.getArgs();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof ClientCallback)) continue;
                    ClientCallback cc = (ClientCallback)args[i];
                    args[i] = ClientCallback.clientCallbackArgProxy(cc, new ServerCallbackProxy(this._factory, message, cc));
                }
            }
            result = method.invoke(this._service, args);
        }
        catch (Throwable ex) {
            Constants.ahessianLogger.warn("", ex);
            fault = ex;
        }
        if (fault == null && result instanceof InputStream) {
            this.handleInputStreamResult(fault, result, message);
        } else {
            this.handleDefaultResult(fault, result, message);
        }
    }
}

