/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.Msg;
import ghidra.util.datastruct.LongIntHashtable;
import ghidra.util.exception.NoValueException;
import ghidra.util.graph.DirectedGraph;
import ghidra.util.graph.Edge;
import ghidra.util.graph.EdgeSet;
import ghidra.util.graph.GraphIterator;
import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.Vertex;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

@Deprecated(since="10.2")
class VertexSet
implements KeyIndexableSet<Vertex> {
    private final DirectedGraph parentGraph;
    private long modificationNumber;
    private int capacity;
    private int nextIndex = 0;
    private LongIntHashtable keyIndices;
    private Edge[] firstOutgoingEdge;
    private Edge[] firstIncomingEdge;
    private Edge[] lastOutgoingEdge;
    private Edge[] lastIncomingEdge;
    private Vertex[] vertices;

    public VertexSet(DirectedGraph parent, int capacity) {
        if (capacity < 10) {
            capacity = 10;
        }
        this.parentGraph = parent;
        this.modificationNumber = 0L;
        this.capacity = capacity;
        this.keyIndices = new LongIntHashtable(capacity);
        this.firstOutgoingEdge = new Edge[capacity];
        this.firstIncomingEdge = new Edge[capacity];
        this.lastOutgoingEdge = new Edge[capacity];
        this.lastIncomingEdge = new Edge[capacity];
        this.vertices = new Vertex[capacity];
    }

    int index(Vertex v) {
        try {
            return this.keyIndices.get(v.key());
        }
        catch (NoValueException exc) {
            return -1;
        }
    }

    @Override
    public boolean add(Vertex v) {
        long key = v.key();
        if (!this.keyIndices.contains(key)) {
            if (this.nextIndex >= this.capacity) {
                this.grow();
            }
            this.keyIndices.put(key, this.nextIndex);
            this.vertices[this.nextIndex++] = v;
            ++this.modificationNumber;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Vertex v) {
        if (v == null) {
            return false;
        }
        long key = v.key();
        try {
            if (this.keyIndices.contains(key)) {
                int index = this.keyIndices.get(key);
                while (this.firstOutgoingEdge[index] != null) {
                    this.parentGraph.remove(this.firstOutgoingEdge[index]);
                }
                while (this.firstIncomingEdge[index] != null) {
                    this.parentGraph.remove(this.firstIncomingEdge[index]);
                }
                this.keyIndices.remove(key);
                this.vertices[index] = null;
                ++this.modificationNumber;
                return true;
            }
        }
        catch (NoValueException e) {
            return false;
        }
        return false;
    }

    @Override
    public int size() {
        return this.keyIndices.size();
    }

    @Override
    public boolean contains(Vertex v) {
        if (v == null) {
            return false;
        }
        return this.keyIndices.contains(v.key());
    }

    private Vertex getByIndex(int index) {
        return this.vertices[index];
    }

    public int numSources() {
        int cnt = 0;
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.firstIncomingEdge[i] != null || this.vertices[i] == null) continue;
            ++cnt;
        }
        return cnt;
    }

    public int numSinks() {
        int cnt = 0;
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.firstOutgoingEdge[i] != null || this.vertices[i] == null) continue;
            ++cnt;
        }
        return cnt;
    }

    Vertex[] getSources() {
        int j = 0;
        int n = this.numSources();
        Vertex[] answer = new Vertex[n];
        for (int i = 0; j < n && i < this.nextIndex; ++i) {
            if (this.firstIncomingEdge[i] != null || this.vertices[i] == null) continue;
            answer[j++] = this.vertices[i];
        }
        return answer;
    }

    Vertex[] getSinks() {
        int j = 0;
        int n = this.numSinks();
        Vertex[] answer = new Vertex[n];
        for (int i = 0; j < n && i < this.nextIndex; ++i) {
            if (this.firstOutgoingEdge[i] != null || this.vertices[i] == null) continue;
            answer[j++] = this.vertices[i];
        }
        return answer;
    }

    Edge getFirstOutgoingEdge(Vertex v) {
        try {
            return this.firstOutgoingEdge[this.keyIndices.get(v.key())];
        }
        catch (NoValueException exc) {
            return null;
        }
    }

    Edge getLastOutgoingEdge(Vertex v) {
        try {
            Edge re;
            Edge e = re = this.firstOutgoingEdge[this.keyIndices.get(v.key())];
            EdgeSet es = this.parentGraph.edges();
            while (e != null) {
                re = e;
                e = es.getNextEdgeWithSameFrom(re);
            }
            return re;
        }
        catch (NoValueException exc) {
            return null;
        }
    }

    Edge getFirstIncomingEdge(Vertex v) {
        try {
            return this.firstIncomingEdge[this.keyIndices.get(v.key())];
        }
        catch (NoValueException exc) {
            return null;
        }
    }

    Edge getLastIncomingEdge(Vertex v) {
        try {
            Edge re;
            Edge e = re = this.firstIncomingEdge[this.keyIndices.get(v.key())];
            EdgeSet es = this.parentGraph.edges();
            while (e != null) {
                re = e;
                e = es.getNextEdgeWithSameTo(re);
            }
            return re;
        }
        catch (NoValueException exc) {
            return null;
        }
    }

    void setFirstOutgoingEdge(Vertex v, Edge e) {
        try {
            this.firstOutgoingEdge[this.index((Vertex)v)] = e;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            Msg.error((Object)this, (Object)("No Value Exception in setFirstOutgoingEdge()\tVertex: " + v.toString() + "\tEdge: " + e.toString()), (Throwable)exc);
        }
    }

    void setLastOutgoingEdge(Vertex v, Edge e) {
        try {
            this.lastOutgoingEdge[this.index((Vertex)v)] = e;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            Msg.error((Object)this, (Object)("No Value Exception in setLastOutgoingEdge()\tVertex: " + v.toString() + "\tEdge: " + e.toString()), (Throwable)exc);
        }
    }

    void setFirstIncomingEdge(Vertex v, Edge e) {
        try {
            this.firstIncomingEdge[this.index((Vertex)v)] = e;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            Msg.error((Object)this, (Object)("No Value Exception in setFirstIncomingEdge()\tVertex: " + v.toString() + "\tEdge: " + e.toString()), (Throwable)exc);
        }
    }

    void setLastIncomingEdge(Vertex v, Edge e) {
        try {
            this.lastIncomingEdge[this.index((Vertex)v)] = e;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            Msg.error((Object)this, (Object)("No Value Exception in setLastIncomingEdge()\tVertex: " + v.toString() + "\tEdge: " + e.toString()), (Throwable)exc);
        }
    }

    void clear() {
        ++this.modificationNumber;
        EdgeSet es = this.parentGraph.edges();
        if (es.size() > 0) {
            es.clear();
        }
        if (this.size() > 0) {
            this.nextIndex = 0;
            this.keyIndices.removeAll();
            for (int i = 0; i < this.capacity; ++i) {
                this.firstOutgoingEdge[i] = null;
                this.firstIncomingEdge[i] = null;
                this.lastOutgoingEdge[i] = null;
                this.lastIncomingEdge[i] = null;
                this.vertices[i] = null;
            }
        }
    }

    @Override
    public Vertex getKeyedObject(long key) {
        if (this.keyIndices.contains(key)) {
            try {
                return this.vertices[this.keyIndices.get(key)];
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    void grow() {
        ++this.modificationNumber;
        if (this.keyIndices.size() * 13 > this.capacity * 9) {
            int newCapacity = (int)Math.round((double)this.keyIndices.size() * 1.7) + 7;
            Edge[] newFirstOutgoingEdge = new Edge[newCapacity];
            Edge[] newFirstIncomingEdge = new Edge[newCapacity];
            Edge[] newLastOutgoingEdge = new Edge[newCapacity];
            Edge[] newLastIncomingEdge = new Edge[newCapacity];
            Vertex[] newVertices = new Vertex[newCapacity];
            this.nextIndex = 0;
            for (int i = 0; i < this.capacity; ++i) {
                if (this.vertices[i] == null) continue;
                newVertices[this.nextIndex] = this.vertices[i];
                newFirstOutgoingEdge[this.nextIndex] = this.firstOutgoingEdge[i];
                newFirstIncomingEdge[this.nextIndex] = this.firstIncomingEdge[i];
                newLastOutgoingEdge[this.nextIndex] = this.lastOutgoingEdge[i];
                newLastIncomingEdge[this.nextIndex] = this.lastIncomingEdge[i];
                this.keyIndices.remove(this.vertices[i].key());
                this.keyIndices.put(this.vertices[i].key(), this.nextIndex);
                ++this.nextIndex;
            }
            this.capacity = newCapacity;
            this.vertices = newVertices;
            this.firstOutgoingEdge = newFirstOutgoingEdge;
            this.firstIncomingEdge = newFirstIncomingEdge;
            this.lastOutgoingEdge = newLastOutgoingEdge;
            this.lastIncomingEdge = newLastIncomingEdge;
        } else {
            this.tighten();
        }
    }

    private void tighten() {
        ++this.modificationNumber;
        this.nextIndex = 0;
        for (int i = 0; i < this.capacity; ++i) {
            if (this.vertices[i] == null) continue;
            if (i > this.nextIndex) {
                this.vertices[this.nextIndex] = this.vertices[i];
                this.firstOutgoingEdge[this.nextIndex] = this.firstOutgoingEdge[i];
                this.firstIncomingEdge[this.nextIndex] = this.firstIncomingEdge[i];
                this.lastOutgoingEdge[this.nextIndex] = this.lastOutgoingEdge[i];
                this.lastIncomingEdge[this.nextIndex] = this.lastIncomingEdge[i];
                this.keyIndices.remove(this.vertices[i].key());
                this.keyIndices.put(this.vertices[i].key(), this.nextIndex);
                this.vertices[i] = null;
                this.firstOutgoingEdge[i] = null;
                this.firstIncomingEdge[i] = null;
                this.lastOutgoingEdge[i] = null;
                this.lastIncomingEdge[i] = null;
            }
            ++this.nextIndex;
        }
    }

    @Override
    public long getModificationNumber() {
        return this.modificationNumber;
    }

    @Override
    public GraphIterator<Vertex> iterator() {
        return new VertexSetIterator();
    }

    public Set<Vertex> toSet() {
        HashSet<Vertex> vs = new HashSet<Vertex>(this.size());
        GraphIterator<Vertex> i = this.iterator();
        while (i.hasNext()) {
            vs.add(i.next());
        }
        return vs;
    }

    public Vertex[] toArray() {
        Vertex[] theVertices = new Vertex[this.size()];
        int i = 0;
        int cnt = 0;
        int done = this.size();
        while (cnt < done) {
            if (this.vertices[i] != null) {
                theVertices[cnt++] = this.vertices[i];
            }
            ++i;
        }
        return theVertices;
    }

    private class VertexSetIterator
    implements GraphIterator<Vertex> {
        private int currentPosition = -1;
        private int nextPosition = -1;
        private long setModificationNumber;

        public VertexSetIterator() {
            this.setModificationNumber = VertexSet.this.getModificationNumber();
            this.getNextPosition();
        }

        private void getNextPosition() {
            ++this.nextPosition;
            while (this.nextPosition < VertexSet.this.capacity() && VertexSet.this.getByIndex(this.nextPosition) == null) {
                ++this.nextPosition;
            }
        }

        @Override
        public boolean hasNext() throws ConcurrentModificationException {
            if (this.setModificationNumber != VertexSet.this.getModificationNumber()) {
                throw new ConcurrentModificationException("Set Modified");
            }
            return this.nextPosition < VertexSet.this.capacity();
        }

        @Override
        public Vertex next() throws ConcurrentModificationException {
            if (this.setModificationNumber != VertexSet.this.getModificationNumber()) {
                throw new ConcurrentModificationException("Set Modified");
            }
            if (this.nextPosition < VertexSet.this.capacity()) {
                this.currentPosition = this.nextPosition;
                this.getNextPosition();
                return VertexSet.this.getByIndex(this.currentPosition);
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean remove() throws ConcurrentModificationException {
            if (this.setModificationNumber != VertexSet.this.getModificationNumber()) {
                throw new ConcurrentModificationException("Set Modified");
            }
            boolean removed = VertexSet.this.remove(VertexSet.this.getByIndex(this.currentPosition));
            this.setModificationNumber = VertexSet.this.getModificationNumber();
            return removed;
        }
    }
}

