/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.ShortKeySet;
import java.io.Serializable;
import java.util.Arrays;

public class BitTree
implements ShortKeySet,
Serializable {
    private static final long serialVersionUID = 1L;
    private int size;
    private int power2;
    private int[] bits;
    private int numKeys;
    private static final int[] setMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE};
    private static final int[] clearMask = new int[]{-2, -3, -5, -9, -17, -33, -65, -129, -257, -513, -1025, -2049, -4097, -8193, -16385, -32769, -65537, -131073, -262145, -524289, -1048577, -2097153, -4194305, -8388609, -16777217, -33554433, -67108865, -134217729, -268435457, -536870913, -1073741825, Integer.MAX_VALUE};

    public BitTree(short maxKey) {
        this(maxKey, false);
    }

    public BitTree(short maxKey, boolean isFull) {
        this.size = maxKey + 1;
        this.power2 = 2;
        int sz = maxKey + 1;
        while (sz > 1) {
            sz /= 2;
            this.power2 *= 2;
        }
        int nInts = this.power2 / 16;
        if (nInts < 1) {
            nInts = 1;
        }
        this.bits = new int[nInts];
        if (isFull) {
            Arrays.fill(this.bits, -1);
            this.numKeys = this.size;
        }
    }

    @Override
    public void removeAll() {
        Arrays.fill(this.bits, 0);
        this.numKeys = 0;
    }

    @Override
    public int size() {
        return this.numKeys;
    }

    @Override
    public void put(short key) {
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int nodeIndex = this.power2 + key;
        if (!this.setBit(nodeIndex)) {
            return;
        }
        ++this.numKeys;
        while (nodeIndex != 1) {
            if (this.setBit(nodeIndex /= 2)) continue;
            return;
        }
    }

    @Override
    public boolean remove(short key) {
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int nodeIndex = this.power2 + key;
        if (!this.clearBit(nodeIndex)) {
            return false;
        }
        --this.numKeys;
        while (nodeIndex != 1) {
            if (!this.isBitSet(nodeIndex /= 2)) {
                return true;
            }
            if (this.isBitSet(nodeIndex * 2) || this.isBitSet(nodeIndex * 2 + 1)) {
                return true;
            }
            this.clearBit(nodeIndex);
        }
        return true;
    }

    @Override
    public boolean containsKey(short key) {
        if (key < 0 || key >= this.size) {
            return false;
        }
        return this.isBitSet(this.power2 + key);
    }

    @Override
    public short getNext(short key) {
        int nodeIndex;
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        for (nodeIndex = key + this.power2; nodeIndex != 1; nodeIndex /= 2) {
            int odd = nodeIndex % 2;
            if (odd != 0 || !this.isBitSet(nodeIndex + 1)) continue;
            ++nodeIndex;
            break;
        }
        if (nodeIndex == 1) {
            return -1;
        }
        while (nodeIndex < this.power2) {
            if (this.isBitSet(nodeIndex *= 2)) continue;
            ++nodeIndex;
        }
        int nextKey = nodeIndex - this.power2;
        if (nextKey >= this.size) {
            nextKey = -1;
        }
        return (short)nextKey;
    }

    @Override
    public short getPrevious(short key) {
        int nodeIndex;
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        for (nodeIndex = key + this.power2; nodeIndex != 1; nodeIndex /= 2) {
            int odd = nodeIndex % 2;
            if (odd != 1 || !this.isBitSet(nodeIndex - 1)) continue;
            --nodeIndex;
            break;
        }
        if (nodeIndex == 1) {
            return -1;
        }
        while (nodeIndex < this.power2) {
            if (!this.isBitSet((nodeIndex *= 2) + 1)) continue;
            ++nodeIndex;
        }
        return (short)(nodeIndex - this.power2);
    }

    @Override
    public boolean isEmpty() {
        return this.numKeys == 0;
    }

    @Override
    public short getFirst() {
        if (this.containsKey((short)0)) {
            return 0;
        }
        return this.getNext((short)0);
    }

    @Override
    public short getLast() {
        if (this.containsKey((short)(this.size - 1))) {
            return (short)(this.size - 1);
        }
        return this.getPrevious((short)(this.size - 1));
    }

    private boolean setBit(int n) {
        int intIndex = n >> 5;
        int maskIndex = n & 0x1F;
        int old = this.bits[intIndex];
        int n2 = intIndex;
        int n3 = this.bits[n2] | setMask[maskIndex];
        this.bits[n2] = n3;
        return n3 != old;
    }

    private boolean clearBit(int n) {
        int intIndex = n >> 5;
        int maskIndex = n & 0x1F;
        int old = this.bits[intIndex];
        int n2 = intIndex;
        int n3 = this.bits[n2] & clearMask[maskIndex];
        this.bits[n2] = n3;
        return n3 != old;
    }

    private boolean isBitSet(int n) {
        int intIndex = n >> 5;
        int maskIndex = n & 0x1F;
        return (this.bits[intIndex] & setMask[maskIndex]) != 0;
    }
}

