/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import ghidra.util.exception.AssertException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class DatabaseInformation {
    public String databasename = "Example Database";
    public String owner = "Example Owner";
    public String description = "A collection of functions for testing purposes";
    public short major = 0;
    public short minor = 0;
    public int settings = 0;
    public List<String> execats = null;
    public List<String> functionTags = null;
    public String dateColumnName = null;
    public int layout_version = 0;
    public boolean readonly = false;
    public boolean trackcallgraph = true;

    public void saveXml(Writer write) throws IOException {
        write.append("<info>\n");
        if (this.databasename != null) {
            write.append(" <name>").append(this.databasename).append("</name>\n");
        } else {
            write.append(" <name/>\n");
        }
        if (this.owner != null) {
            write.append(" <owner>").append(this.owner).append("</owner>\n");
        } else {
            write.append(" <owner/>\n");
        }
        if (this.description != null) {
            write.append(" <description>").append(this.description).append("</description>\n");
        } else {
            write.append(" <description/>\n");
        }
        write.append(" <major>").append(Short.toString(this.major)).append("</major>\n");
        write.append(" <minor>").append(Short.toString(this.minor)).append("</minor>\n");
        write.append(" <settings>0x").append(Integer.toHexString(this.settings)).append("</settings>\n");
        if (this.execats != null) {
            for (String cat : this.execats) {
                write.append(" <execategory>").append(cat).append("</execategory>\n");
            }
        }
        if (this.functionTags != null) {
            for (String tag : this.functionTags) {
                write.append(" <functiontag>").append(tag).append("</functiontag>\n");
            }
        }
        if (this.dateColumnName != null) {
            write.append(" <datename>").append(this.dateColumnName).append("</datename>\n");
        }
        if (this.readonly) {
            write.append(" <readonly>true</readonly>\n");
        }
        if (!this.trackcallgraph) {
            write.append(" <trackcallgraph>false</trackcallgraph>\n");
        }
        write.append(" <layout>").append(Integer.toString(this.layout_version)).append("</layout>\n");
        write.append("</info>\n");
    }

    public void restoreXml(XmlPullParser parser) {
        parser.start(new String[]{"info"});
        parser.start(new String[]{"name"});
        this.databasename = parser.end().getText();
        if (this.databasename.length() == 0) {
            this.databasename = null;
        }
        parser.start(new String[]{"owner"});
        this.owner = parser.end().getText();
        if (this.owner.length() == 0) {
            this.owner = null;
        }
        parser.start(new String[]{"description"});
        this.description = parser.end().getText();
        if (this.description.length() == 0) {
            this.description = null;
        }
        parser.start(new String[]{"major"});
        this.major = (short)SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"minor"});
        this.minor = (short)SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"settings"});
        this.settings = SpecXmlUtils.decodeInt((String)parser.end().getText());
        this.readonly = false;
        this.trackcallgraph = true;
        this.layout_version = 0;
        this.execats = null;
        this.functionTags = null;
        this.dateColumnName = null;
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            if (el.getName().equals("readonly")) {
                this.readonly = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
                continue;
            }
            if (el.getName().equals("trackcallgraph")) {
                this.trackcallgraph = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
                continue;
            }
            if (el.getName().equals("layout")) {
                this.layout_version = SpecXmlUtils.decodeInt((String)parser.end().getText());
                continue;
            }
            if (el.getName().equals("execategory")) {
                if (this.execats == null) {
                    this.execats = new ArrayList<String>();
                }
                String cat = parser.end().getText();
                this.execats.add(cat);
                continue;
            }
            if (el.getName().equals("functiontag")) {
                if (this.functionTags == null) {
                    this.functionTags = new ArrayList<String>();
                }
                String tag = parser.end().getText();
                this.functionTags.add(tag);
                continue;
            }
            if (!el.getName().equals("datename")) continue;
            this.dateColumnName = parser.end().getText();
        }
        parser.end();
    }

    public boolean equals(Object obj) {
        throw new AssertException("DatabaseInformation.equals is used - should add hashcode method");
    }

    public int checkSignatureSettings(short maj, short min, int set) {
        if (maj == 0 || set == 0) {
            return 3;
        }
        if (this.major == 0 || this.settings == 0) {
            return 4;
        }
        if (this.major != maj || this.settings != set) {
            return 2;
        }
        if (this.minor == min) {
            return 0;
        }
        if (this.minor > min ? this.minor - min > 1 : min - this.minor > 1) {
            return 2;
        }
        return 1;
    }
}

