/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.isf;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.base.project.GhidraProject;
import ghidra.dbg.isf.IsfServer;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.framework.model.ProjectLocator;
import ghidra.util.Msg;
import java.io.File;
import utility.application.ApplicationLayout;

public class IsfServerLauncher
implements GhidraLaunchable {
    private GhidraProject project = null;
    private IsfServer server;
    private int port;

    public void launch(GhidraApplicationLayout layout, String[] args) throws Exception {
        HeadlessGhidraApplicationConfiguration config = new HeadlessGhidraApplicationConfiguration();
        if (!Application.isInitialized()) {
            Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)config);
        }
        GhidraProject proj = this.parseArgs(args);
        this.server = new IsfServer(proj, this.port);
        this.server.startServer();
    }

    GhidraProject parseArgs(String[] args) throws Exception {
        if (args != null && args.length < 1) {
            this.usage();
            return null;
        }
        this.port = Integer.parseInt(args[0]);
        if (args.length > 1) {
            ProjectLocator locator;
            String projectLocation = args[1];
            String projectName = args[2];
            File dir = new File(projectLocation);
            if (dir.exists() && (locator = new ProjectLocator(dir.getAbsolutePath(), projectName)).getProjectDir().exists()) {
                this.project = GhidraProject.openProject((String)projectLocation, (String)projectName);
            }
        }
        return this.project;
    }

    public int getPort() {
        return this.port;
    }

    public void close() {
        this.server.stopServer();
        if (this.project != null) {
            this.project.close();
        }
    }

    public void usage() {
        Msg.error((Object)this, (Object)"Usage: runISFServer <port> <project_location> <project_name> ");
    }
}

