/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SymbolGroup {
    public static final int PUBLIC_GLOBAL_MODULE_NUMBER = 0;
    private AbstractPdb pdb;
    private Map<Long, AbstractMsSymbol> symbolsByOffset;
    private int moduleNumber;
    private List<Long> offsets;
    private Map<Long, Integer> indexByOffset;

    public SymbolGroup(AbstractPdb pdb, int moduleNumber) {
        this.pdb = pdb;
        this.moduleNumber = moduleNumber;
    }

    public SymbolGroup(Map<Long, AbstractMsSymbol> symbolsByOffset, int moduleNumber) {
        this(symbolsByOffset, moduleNumber, 0L);
    }

    public SymbolGroup(Map<Long, AbstractMsSymbol> symbolsByOffset, int moduleNumber, long offset) {
        this.symbolsByOffset = symbolsByOffset;
        this.moduleNumber = moduleNumber;
        this.initOffsets();
    }

    List<AbstractMsSymbol> getSymbols() {
        return new ArrayList<AbstractMsSymbol>(this.symbolsByOffset.values());
    }

    int getModuleNumber() {
        return this.moduleNumber;
    }

    int size() {
        return this.symbolsByOffset.size();
    }

    List<Long> getOrderedOffsets() {
        return new ArrayList<Long>(this.symbolsByOffset.keySet());
    }

    Set<Long> getOffsets() {
        return this.symbolsByOffset.keySet();
    }

    List<AbstractMsSymbol> getOrderedSymbols() {
        ArrayList<AbstractMsSymbol> symbols = new ArrayList<AbstractMsSymbol>();
        for (long offset : this.offsets) {
            symbols.add(this.symbolsByOffset.get(offset));
        }
        return symbols;
    }

    private void initOffsets() {
        this.offsets = new ArrayList<Long>();
        this.indexByOffset = new HashMap<Long, Integer>();
        int index = 0;
        for (Map.Entry<Long, AbstractMsSymbol> entry : this.symbolsByOffset.entrySet()) {
            this.offsets.add(index, entry.getKey());
            this.indexByOffset.put(entry.getKey(), index++);
        }
    }

    protected void dump(Writer writer) throws IOException {
        writer.write("SymbolGroup-------------------------------------------------");
        for (Map.Entry<Long, AbstractMsSymbol> entry : this.symbolsByOffset.entrySet()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n------------------------------------------------------------\n");
            builder.append(String.format("Offset: 0X%08X\n", entry.getKey()));
            builder.append(entry.getValue());
            writer.write(builder.toString());
        }
        writer.write("\nEnd SymbolGroup---------------------------------------------\n");
    }

    public MsSymbolIterator getSymbolIterator() throws PdbException {
        int lengthSymbols;
        int startingOffset;
        int streamNumber;
        if (this.moduleNumber == 0) {
            streamNumber = this.pdb.getDebugInfo().getSymbolRecordsStreamNumber();
            startingOffset = 0;
            lengthSymbols = Integer.MAX_VALUE;
        } else {
            ModuleInformation moduleInfo = this.pdb.getDebugInfo().getModuleInformation(this.moduleNumber);
            streamNumber = moduleInfo.getStreamNumberDebugInformation();
            lengthSymbols = moduleInfo.getSizeLocalSymbolsDebugInformation();
            try {
                startingOffset = this.pdb.getDebugInfo().getSymbolRecords().getCvSigLength(streamNumber);
            }
            catch (CancelledException e) {
                startingOffset = 0;
                lengthSymbols = 0;
            }
        }
        return new MsSymbolIterator(this.pdb, streamNumber, startingOffset, lengthSymbols);
    }
}

