/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface MemoryAdapter
extends Memory {
    default public ByteBuffer mustRead(Address addr, int length, boolean bigEndian) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(length);
        if (this.getBytes(addr, buf.array()) != length) {
            throw new MemoryAccessException();
        }
        buf.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    default public int getBytes(Address addr, byte[] dest) throws MemoryAccessException {
        return this.getBytes(addr, dest, 0, dest.length);
    }

    default public byte getByte(Address addr) throws MemoryAccessException {
        return this.mustRead(addr, 1, true).get(0);
    }

    default public short getShort(Address addr) throws MemoryAccessException {
        return this.mustRead(addr, 2, true).getShort(0);
    }

    default public short getShort(Address addr, boolean bigEndian) throws MemoryAccessException {
        return this.mustRead(addr, 2, bigEndian).getShort(0);
    }

    default public int getShorts(Address addr, short[] dest) throws MemoryAccessException {
        return this.getShorts(addr, dest, 0, dest.length, true);
    }

    default public int getShorts(Address addr, short[] dest, int dIndex, int nElem) throws MemoryAccessException {
        return this.getShorts(addr, dest, dIndex, nElem, true);
    }

    default public int getShorts(Address addr, short[] dest, int dIndex, int nElem, boolean bigEndian) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(2 * nElem);
        int got = this.getBytes(addr, buf.array()) / 2;
        buf.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buf.asShortBuffer().get(dest, dIndex, got);
        return got;
    }

    default public int getInt(Address addr) throws MemoryAccessException {
        return this.mustRead(addr, 4, true).getInt(0);
    }

    default public int getInt(Address addr, boolean bigEndian) throws MemoryAccessException {
        return this.mustRead(addr, 4, bigEndian).getInt(0);
    }

    default public int getInts(Address addr, int[] dest) throws MemoryAccessException {
        return this.getInts(addr, dest, 0, dest.length, true);
    }

    default public int getInts(Address addr, int[] dest, int dIndex, int nElem) throws MemoryAccessException {
        return this.getInts(addr, dest, dIndex, nElem, true);
    }

    default public int getInts(Address addr, int[] dest, int dIndex, int nElem, boolean bigEndian) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(4 * nElem);
        int got = this.getBytes(addr, buf.array()) / 4;
        buf.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buf.asIntBuffer().get(dest, dIndex, got);
        return got;
    }

    default public long getLong(Address addr) throws MemoryAccessException {
        return this.mustRead(addr, 8, true).getLong(0);
    }

    default public long getLong(Address addr, boolean bigEndian) throws MemoryAccessException {
        return this.mustRead(addr, 8, bigEndian).getLong(0);
    }

    default public int getLongs(Address addr, long[] dest) throws MemoryAccessException {
        return this.getLongs(addr, dest, 0, dest.length, true);
    }

    default public int getLongs(Address addr, long[] dest, int dIndex, int nElem) throws MemoryAccessException {
        return this.getLongs(addr, dest, dIndex, nElem, true);
    }

    default public int getLongs(Address addr, long[] dest, int dIndex, int nElem, boolean bigEndian) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(8 * nElem);
        int got = this.getBytes(addr, buf.array()) / 8;
        buf.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buf.asLongBuffer().get(dest, dIndex, got);
        return got;
    }

    default public void setBytes(Address addr, byte[] source) throws MemoryAccessException {
        this.setBytes(addr, source, 0, source.length);
    }

    default public void setByte(Address addr, byte value) throws MemoryAccessException {
        this.setBytes(addr, new byte[]{value});
    }

    default public void setShort(Address addr, short value) throws MemoryAccessException {
        this.setShort(addr, value, true);
    }

    default public void setShort(Address addr, short value, boolean bigEndian) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buf.putShort(value);
        this.setBytes(addr, buf.array());
    }

    default public void setInt(Address addr, int value) throws MemoryAccessException {
        this.setInt(addr, value, true);
    }

    default public void setInt(Address addr, int value, boolean bigEndian) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buf.putInt(value);
        this.setBytes(addr, buf.array());
    }

    default public void setLong(Address addr, long value) throws MemoryAccessException {
        this.setLong(addr, value, true);
    }

    default public void setLong(Address addr, long value, boolean bigEndian) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buf.putLong(value);
        this.setBytes(addr, buf.array());
    }
}

