/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DBTraceObjectStackFrame
implements TraceObjectStackFrame,
DBTraceObjectInterface {
    private static final Map<TraceObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TraceObjectSchema, Set<String>>();
    private final DBTraceObject object;
    private final Set<String> keys;
    private Lifespan.LifeSet life = new Lifespan.DefaultLifeSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTraceObjectStackFrame(DBTraceObject object) {
        this.object = object;
        TraceObjectSchema schema = object.getSchema();
        Map<TraceObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
        synchronized (map) {
            this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(schema.checkAliasedAttribute("_pc")));
        }
    }

    @Override
    public TraceObjectStack getStack() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceObjectStack traceObjectStack = this.object.queryCanonicalAncestorsInterface(TraceObjectStack.class).findAny().orElseThrow();
            return traceObjectStack;
        }
    }

    @Override
    public int getLevel() {
        KeyPath path = this.object.getCanonicalPath();
        for (int i = path.size() - 1; i >= 0; --i) {
            String k = path.key(i);
            if (!KeyPath.isIndex(k)) continue;
            String index = KeyPath.parseIndex(k);
            try {
                return Integer.decode(index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Frame has no index!?");
    }

    @Override
    public Address getProgramCounter(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_pc", Address.class, null);
    }

    @Override
    public void setProgramCounter(Lifespan span, Address pc) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            if (pc == Address.NO_ADDRESS) {
                pc = null;
            }
            this.object.setValue(span, "_pc", pc);
        }
    }

    @Override
    public String getComment(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Address pc = this.getProgramCounter(snap);
            String string = pc == null ? null : this.object.getTrace().getCommentAdapter().getComment(snap, pc, CommentType.EOL);
            return string;
        }
    }

    @Override
    public void setComment(long snap, String comment) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            DBTraceObjectValue pcAttr = this.object.getValue(snap, "_pc");
            this.object.getTrace().getCommentAdapter().setComment(pcAttr.getLifespan(), (Address)pcAttr.getValue(), CommentType.EOL, comment);
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    protected boolean changeApplies(TraceChangeRecord<?, ?> rec) {
        TraceChangeRecord cast = TraceEvents.VALUE_CREATED.cast(rec);
        TraceObjectValue affected = (TraceObjectValue)cast.getAffectedObject();
        assert (affected.getParent() == this.object);
        if (!this.keys.contains(affected.getEntryKey())) {
            return false;
        }
        return this.object.getCanonicalParent(affected.getMaxSnap()) != null;
    }

    protected TraceChangeRecord<?, ?> createChangeRecord() {
        return new TraceChangeRecord<TraceObjectStack, Long>(TraceEvents.STACK_CHANGED, null, this.getStack(), 0L, ((Lifespan)this.life.bound()).lmin());
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        EventType type = rec.getEventType();
        if (type == TraceEvents.OBJECT_LIFE_CHANGED) {
            Lifespan.LifeSet newLife = this.object.getLife();
            if (!newLife.isEmpty()) {
                this.life = newLife;
            }
            return this.createChangeRecord();
        }
        if (type == TraceEvents.VALUE_CREATED && this.changeApplies(rec)) {
            return this.createChangeRecord();
        }
        if (type == TraceEvents.OBJECT_DELETED) {
            if (this.life.isEmpty()) {
                return null;
            }
            return this.createChangeRecord();
        }
        return null;
    }
}

